/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.common.util.DeploymentFilePathHelper;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.GenericHelper;
import com.urbancode.airplugins.AirPluginTool;
import com.urbancode.commons.util.ssl.XTrustProvider;
import com.urbancode.ud.client.EnvironmentClient;
import java.io.File;
import java.net.URI;
import java.util.Properties;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class RemoveAllVersions {
    public static void main(String[] args) {
        int ERR_CODE = 8;
        try {
            String pathContainsVersions;
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            boolean isDryRun = Boolean.parseBoolean(inputProperties.getProperty("isDryRun"));
            String resourceId = inputProperties.getProperty("resourceId");
            String applicationName = inputProperties.getProperty("applicationName");
            String environmentName = inputProperties.getProperty("environmentName");
            String componentName = inputProperties.getProperty("componentName");
            String deployBasePath = inputProperties.getProperty("deployBasePath");
            if (GenericHelper.isNullOrEmpty(applicationName)) {
                System.out.println(" [Error] Application name is either null or empty.");
                System.exit(8);
            }
            if (GenericHelper.isNullOrEmpty(environmentName)) {
                System.out.println(" [Error] Environment name is either null or empty.");
                System.exit(8);
            }
            if (GenericHelper.isNullOrEmpty(componentName)) {
                System.out.println(" [Error] Component name is either null or empty.");
                System.exit(8);
            }
            if (GenericHelper.isNullOrEmpty(deployBasePath)) {
                System.out.println(" [Error] Deploy base path is either null or empty.");
                System.exit(8);
            }
            if (FileHelper.isDirectoryNotExist(pathContainsVersions = DeploymentFilePathHelper.getComponentPathInDeployBasePath(deployBasePath, resourceId, componentName))) {
                System.out.println(" [Error] Component directory does not exist - " + pathContainsVersions);
                System.exit(8);
            }
            String udUser = apTool.getAuthTokenUsername();
            String udPass = apTool.getAuthToken();
            String webUrl = System.getenv("AH_WEB_URL");
            EnvironmentClient envClient = new EnvironmentClient(new URI(webUrl), udUser, udPass);
            XTrustProvider.install();
            JSONArray versions = envClient.deleteAllVersions(environmentName, applicationName, componentName, !isDryRun);
            int length = versions.length();
            System.out.println();
            System.out.println("Application : " + applicationName);
            System.out.println("Environment : " + environmentName);
            System.out.println("Component   : " + componentName);
            System.out.println();
            if (length > 0) {
                int counter = 0;
                if (isDryRun) {
                    System.out.println("Versions to be removed:");
                    System.out.println("-----------------------------------");
                    for (int i = 0; i < length; ++i) {
                        JSONObject version = versions.getJSONObject(i);
                        if (null == version || !version.has("name") || GenericHelper.isNullOrEmpty(version.getString("name"))) continue;
                        ++counter;
                        System.out.println(version.getString("name"));
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        JSONObject version = versions.getJSONObject(i);
                        if (null == version || !version.has("name") || GenericHelper.isNullOrEmpty(version.getString("name"))) continue;
                        String versionName = version.getString("name");
                        System.out.println("Removed version:" + versionName);
                        File versionPathToDel = new File(pathContainsVersions + File.separator + versionName);
                        if (!versionPathToDel.isDirectory()) continue;
                        ++counter;
                        FileHelper.cleanDirectory(versionPathToDel.getCanonicalPath());
                    }
                }
                System.out.println("\n Total number of versions - " + counter);
            } else {
                System.out.println("No versions to remove");
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Error while removing all versions: " + e.getMessage());
            e.printStackTrace();
            System.exit(8);
        }
    }
}

