/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.JFCB;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;

class Bsam {
    public static final String JZOS_BSAM_ALLOW_ABENDS_PROPERTY = "jzos.bsam.allow.abends";
    public static final String JZOS_BSAM_DISABLE_PROPERTY = "jzos.bsam.disable";
    public static final int OPEN_INPUT = 128;
    public static final int OPEN_OUTPUT = 64;
    public static final int ALLOW_ABENDS = 2;
    public static final int DCB_RECFM_F = 128;
    public static final int DCB_RECFM_V = 64;
    public static final int DCB_RECFM_B = 16;
    public static final int DCB_RECFM_S = 8;
    public static final int DCB_RECFM_A = 4;
    public static final int DCB_RECFM_M = 2;
    private String ddname;
    private String dsn;
    private long hBsamImpl;
    private int openMode;
    private int lrecl;
    private int blksize;
    private int recfmBits;

    public static JFCB readJFCB(String ddname) throws ZFileException {
        return new JFCB(Bsam.rdjfcb(ddname));
    }

    public Bsam(String ddname, int openMode) throws ZFileException, UnsupportedOperationException {
        if (System.getProperty(JZOS_BSAM_DISABLE_PROPERTY, "false").equalsIgnoreCase("true")) {
            throw new UnsupportedOperationException("BSAM support disabled via jzos.bsam.disable=true");
        }
        this.openMode = openMode;
        if (System.getProperty(JZOS_BSAM_ALLOW_ABENDS_PROPERTY, "false").equalsIgnoreCase("true")) {
            ZUtil.logDiagnostic(5, "Establishment of ABEND handlers is disabled in BSAM via jzos.bsam.allow.abends=true");
            this.openMode |= 2;
        }
        this.ddname = ddname;
        this.hBsamImpl = this.open(ddname, this.openMode);
        this.dsn = this.getDsnAndMember(this.hBsamImpl);
        this.lrecl = this.getLrecl(this.hBsamImpl);
        this.blksize = this.getBlksize(this.hBsamImpl);
        this.calculateRecfmBits(this.getRecfm(this.hBsamImpl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws ZFileException {
        if (!this.isOpen()) {
            return;
        }
        try {
            this.close(this.hBsamImpl);
        }
        finally {
            this.hBsamImpl = 0L;
        }
    }

    public void flush() throws ZFileException {
        if (!this.isOpen()) {
            return;
        }
        this.flush(this.hBsamImpl);
    }

    public boolean isOpen() {
        return this.hBsamImpl != 0L;
    }

    public int getLrecl() {
        return this.lrecl;
    }

    public int getBlksize() {
        return this.blksize;
    }

    public String getDsn() {
        return this.dsn;
    }

    public int getRecfmBits() {
        return this.recfmBits;
    }

    public String getRecfm() {
        int recfm = this.getRecfmBits();
        StringBuffer sb = new StringBuffer(4);
        if ((recfm & 1) != 0) {
            sb.append("F");
        } else if ((recfm & 2) != 0) {
            sb.append("V");
        } else if ((recfm & 4) != 0) {
            sb.append("U");
        } else {
            return "";
        }
        if ((recfm & 8) != 0) {
            sb.append("B");
        }
        if ((recfm & 0x10) != 0) {
            sb.append("S");
        }
        if ((recfm & 0x20) != 0) {
            sb.append("M");
        }
        if ((recfm & 0x40) != 0) {
            sb.append("A");
        }
        return sb.toString();
    }

    public String getDDName() {
        return this.ddname;
    }

    public int readBlock(byte[] buffer) throws ZFileException {
        return this.readBlock(this.hBsamImpl, buffer, 0, buffer.length);
    }

    public int readBlock(byte[] buffer, int offset, int blocklen) throws ZFileException {
        return this.readBlock(this.hBsamImpl, buffer, offset, blocklen);
    }

    public void writeBlock(byte[] buffer) throws ZFileException {
        this.writeBlock(this.hBsamImpl, buffer, 0, buffer.length);
    }

    public void writeBlock(byte[] buffer, int offset, int blocklen) throws ZFileException {
        this.writeBlock(this.hBsamImpl, buffer, offset, blocklen);
    }

    ZFileException newZFileException(String message, int errno) {
        String filename = this.dsn != null && this.dsn.length() > 0 ? this.dsn : "DD:" + this.ddname;
        return new ZFileException(filename, message, errno);
    }

    private void calculateRecfmBits(int dcbrecfm) {
        this.recfmBits = (dcbrecfm & 0x80) != 0 ? ((dcbrecfm & 0x40) != 0 ? (this.recfmBits += 4) : ++this.recfmBits) : (this.recfmBits += 2);
        if ((dcbrecfm & 0x10) != 0) {
            this.recfmBits += 8;
        }
        if ((dcbrecfm & 8) != 0) {
            this.recfmBits += 16;
        }
        if ((dcbrecfm & 4) != 0) {
            this.recfmBits += 64;
        }
        if ((dcbrecfm & 2) != 0) {
            this.recfmBits += 32;
        }
    }

    private static native byte[] rdjfcb(String var0) throws ZFileException;

    private native long open(String var1, int var2) throws ZFileException, UnsupportedOperationException;

    private native void close(long var1) throws ZFileException;

    private native String getDsnAndMember(long var1) throws ZFileException;

    private native int getLrecl(long var1) throws ZFileException;

    private native int getBlksize(long var1) throws ZFileException;

    private native int getRecfm(long var1) throws ZFileException;

    private native int readBlock(long var1, byte[] var3, int var4, int var5) throws ZFileException;

    private native void writeBlock(long var1, byte[] var3, int var4, int var5) throws ZFileException;

    private native void flush(long var1) throws ZFileException;

    static {
        ZUtil.touch();
    }
}

