/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.GenericHelper;
import java.io.File;
import java.io.IOException;

public final class DeploymentFilePathHelper {
    private static final File workingDir = new File(".");

    private DeploymentFilePathHelper() {
    }

    public static String getVersionDirPathInWorkingDir(String versionName, String resourceId) throws IOException {
        return workingDir.getCanonicalPath() + File.separator + resourceId + File.separator + versionName;
    }

    public static String getFilePathInWorkingDir(String versionName, String resourceId, String fileName) throws IOException {
        return DeploymentFilePathHelper.getVersionDirPathInWorkingDir(versionName, resourceId) + File.separator + fileName;
    }

    public static String getVersionDirPathInRepository(String basePath, String componentName, String versionName) {
        return basePath + File.separator + componentName + File.separator + versionName;
    }

    public static String getFilePathInRepository(String basePath, String componentName, String versionName, String fileName) {
        return DeploymentFilePathHelper.getVersionDirPathInRepository(basePath, componentName, versionName) + File.separator + fileName;
    }

    public static String getVersionPathInDeployBasePath(String basePath, String resourceId, String componentName, String versionName, boolean compatible) {
        String basePathToVersion = basePath + File.separator + "deploy" + File.separator + resourceId + File.separator + componentName + File.separator + versionName;
        if (compatible && FileHelper.isDirectoryNotExist(basePathToVersion)) {
            basePathToVersion = basePath + File.separator + "deploy" + File.separator + componentName + File.separator + versionName;
        }
        return basePathToVersion;
    }

    public static String getComponentPathInDeployBasePath(String basePath, String resourceId, String componentName) {
        String basePathToComponent = GenericHelper.isNullOrEmpty(resourceId) ? basePath + File.separator + "deploy" + File.separator + componentName : basePath + File.separator + "deploy" + File.separator + resourceId + File.separator + componentName;
        return basePathToComponent;
    }
}

