/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import com.ibm.urbancode.zos.common.util.SystemEnv;
import com.ibm.urbancode.zos.zinventory.ZInventoryException;
import com.urbancode.air.AirPluginTool;
import com.urbancode.commons.util.IO;
import com.urbancode.ud.client.UDRestClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;

public class ServerAPIServicesHelper {
    private static final int SUCCESS_CODE = 204;
    private final String udUser;
    private final String udPassword;
    private static final String ZINVENTORY_BASE_PATH = "/cli/zInventory";
    private static final String ROLLBACK_PATH = "/rollback";
    private final String serverUrl;

    public ServerAPIServicesHelper(AirPluginTool aptool) {
        this.udUser = aptool.getAuthTokenUsername();
        this.udPassword = aptool.getAuthToken();
        this.serverUrl = SystemEnv.getServerUrl();
    }

    public void addDeploymentDataToZInventoryTable(String requestBody) throws IOException, URISyntaxException {
        try (DefaultHttpClient httpClient = UDRestClient.createHttpClient((String)this.udUser, (String)this.udPassword, (boolean)true);){
            URI uri = new URI(this.serverUrl + ZINVENTORY_BASE_PATH);
            HttpPost method = new HttpPost(uri);
            method.setEntity((HttpEntity)new StringEntity(requestBody));
            this.invokeMethod((HttpRequestBase)method, httpClient);
        }
    }

    public void rollbackDataInZInventoryTable(List<NameValuePair> params) throws URISyntaxException, IOException {
        try (DefaultHttpClient httpClient = UDRestClient.createHttpClient((String)this.udUser, (String)this.udPassword, (boolean)true);){
            URI uri = new URIBuilder(this.serverUrl + ZINVENTORY_BASE_PATH + ROLLBACK_PATH).addParameters(params).build();
            HttpPost method = new HttpPost(uri);
            this.invokeMethod((HttpRequestBase)method, httpClient);
        }
    }

    private String getBody(CloseableHttpResponse response) throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStream body = response.getEntity().getContent();
        if (body != null) {
            try (InputStreamReader reader = IO.reader(body, IO.utf8());){
                IO.copy((Reader)reader, builder);
            }
        }
        return builder.toString();
    }

    private void invokeMethod(HttpRequestBase request, DefaultHttpClient httpClient) throws IOException {
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
        if (response.getStatusLine().getStatusCode() != 204) {
            throw new ZInventoryException("Status code - " + response.getStatusLine().getStatusCode() + "\nReason phrase" + response.getStatusLine().getReasonPhrase() + "\n" + this.getBody(response));
        }
        System.out.println("Added Data to ZInventory");
    }
}

