/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.common.util.MVSHelper;
import com.ibm.urbancode.zos.dataset.alloc.AllocateCommand;
import com.ibm.urbancode.zos.dataset.alloc.AllocateCommandBuilder;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.urbancode.air.plugin.inputs.AllocateDatasetSmsInputs;
import java.util.Properties;

public class AllocateDatasetSms {
    public static final String OUTPUT_PROPERTY_DATASET_NAME = "DatasetName";
    private final Properties inputProperties;
    private final Properties outputProperties;

    public AllocateDatasetSms(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            AllocateDatasetSmsInputs pluginInputs = new AllocateDatasetSmsInputs(this.inputProperties);
            pluginInputs.validate();
            if (pluginInputs.isDeleteDatasetEnabled()) {
                DatasetHelper.deleteDataset(pluginInputs.getDatasetName());
            }
            AllocateCommand allocateCommand = this.getAllocateCommand(pluginInputs);
            allocateCommand.execute();
            String actualDatasetName = DatasetHelper.isGDGDatasetWithReference(pluginInputs.getDatasetName()) ? MVSHelper.getGDGNameAssignedToDD(allocateCommand.getDDName()) : pluginInputs.getDatasetName();
            allocateCommand.freeDDName();
            System.out.println(" [INFO] Dataset " + actualDatasetName + " is created.");
            this.outputProperties.put(OUTPUT_PROPERTY_DATASET_NAME, actualDatasetName);
            return 0;
        }
        catch (RuntimeException runtimeException) {
            System.out.println(" [Error] " + runtimeException.getMessage());
        }
        catch (ZFileException zFileException) {
            zFileException.printStackTrace();
        }
        return 1;
    }

    private AllocateCommand getAllocateCommand(AllocateDatasetSmsInputs pluginInputs) {
        return new AllocateCommandBuilder(pluginInputs.getDatasetName()).withManagementClass(pluginInputs.getManagementClass()).withStorageClass(pluginInputs.getStorageClass()).withDataClass(pluginInputs.getDataClass()).withReuseNewCatalogDisposition().build();
    }
}

