/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import com.ibm.urbancode.zos.common.util.SystemEnv;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Properties;

public class AgentInstalledProperties {
    private static final String CONF = "conf";
    private static final String AGENT = "agent";
    private static final String INSTALLED_PROPERTIES = "installed.properties";
    private static final String MVS_SYSOUT_CLASS = "mvs.sysoutclass";
    private static final String MVS_TEMP_UNIT = "mvs.tempunit";
    private static final String MVS_TEMP_VOLSER = "mvs.tempvolser";
    private static final String EMPTY_STRING = "";
    private final Properties installedProperties = new Properties();

    public AgentInstalledProperties() {
        String installedPropertiesPath = SystemEnv.getAgentHome() + File.separator + CONF + File.separator + AGENT + File.separator + INSTALLED_PROPERTIES;
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(installedPropertiesPath, new String[0]), StandardCharsets.UTF_8);){
            this.installedProperties.load(reader);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException.getMessage());
        }
    }

    public String getSysoutClass() {
        return this.installedProperties.getProperty(MVS_SYSOUT_CLASS, EMPTY_STRING);
    }

    public String getTempUnit() {
        return this.installedProperties.getProperty(MVS_TEMP_UNIT, EMPTY_STRING);
    }

    public String getTempVolser() {
        return this.installedProperties.getProperty(MVS_TEMP_VOLSER, EMPTY_STRING);
    }
}

