/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.zinventory;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class TimeTracker {
    public static final String DEPLOY_TIME = "DEPLOY_TIME";
    private final String timeTrackerPath;
    private final File timeTrackerFile;

    public TimeTracker(String timeTrackerPath) {
        this.timeTrackerPath = timeTrackerPath;
        this.timeTrackerFile = new File(timeTrackerPath);
    }

    public void setDeployTimeInTimeTrackerFile() throws IOException {
        if (this.timeTrackerFile.createNewFile()) {
            Properties props = new Properties();
            props.setProperty(DEPLOY_TIME, TimeTracker.getCurrentTimeStamp());
            try (FileWriter writer = new FileWriter(this.timeTrackerFile);){
                props.store(writer, "store the current time to Filewriter");
            }
        } else {
            throw new RuntimeException("Failed to create file:- " + this.timeTrackerPath);
        }
    }

    private static String getCurrentTimeStamp() {
        return String.valueOf(System.currentTimeMillis());
    }

    public long getDeployTime() throws IOException {
        if (this.timeTrackerFile.isFile()) {
            return Long.parseLong(this.getDeployTimeFromTimeTrackerFile());
        }
        return Long.parseLong(TimeTracker.getCurrentTimeStamp());
    }

    private String getDeployTimeFromTimeTrackerFile() throws IOException {
        Properties props = new Properties();
        try (FileReader reader = new FileReader(this.timeTrackerFile);){
            props.load(reader);
        }
        return (String)props.get(DEPLOY_TIME);
    }
}

