/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;

public final class FileHelper {
    private FileHelper() {
    }

    public static boolean isFileNotExist(String filePath) {
        return !FileHelper.isFileExist(filePath);
    }

    public static boolean isFileExist(String filePath) {
        return new File(filePath).isFile();
    }

    public static void cleanDirectory(String directoryPath) throws IOException {
        File file = new File(directoryPath);
        if (file.isDirectory()) {
            FileUtils.deleteDirectory((File)file);
        }
    }

    public static boolean isDirectoryNotExist(String directoryPath) {
        return !new File(directoryPath).isDirectory();
    }

    public static void changeEncodingAttributeToIBM1047(String xmlFilePath) throws IOException {
        Path path = Paths.get(xmlFilePath, new String[0]);
        String content = new String(Files.readAllBytes(path));
        content = content.replace("xml version=\"1.0\" encoding=\"UTF-8\"", "xml version=\"1.0\" encoding=\"IBM-1047\"");
        Files.write(path, content.getBytes(), new OpenOption[0]);
    }
}

