/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.dataset.util;

import com.ibm.jzos.CatalogSearch;
import com.ibm.jzos.CatalogSearchField;
import com.ibm.jzos.PdsDirectory;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import com.ibm.urbancode.zos.common.util.GenericHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;

public class DataSetReader {
    static final String SLASH_SLASH_PREFIX = "//";
    static final String DD_PREFIX = "DD:";
    static final String DSNAME_CHAR = "[\\w[#\\$\\.]]";
    static final String DSNAME_PATTERN_CHAR = "[\\w[#\\$\\.\\*]]";
    static final String MEMBER_CHAR = "[\\w[#\\$]";
    static final String MEMBER__PATTERN_CHAR = "[\\w[#\\$\\*]]";
    static final String DSNAME_PIECE = "[\\w[#\\$\\.]]{1,44}";
    static final String DDNAME_PIECE = "DD:\\w{1,8}";
    static final String DSNAME_PATTERN = "^[\\w[#\\$\\.]]+\\*[\\w[#\\$\\.\\*]]*$";
    static final String DSNAME_WITH_MEMBER_OR_PATTERN = "^([\\w[#\\$\\.]]{1,44}|DD:\\w{1,8})\\(([\\w[#\\$\\*]]+)\\)$";
    static final int BUFSIZE = 65536;
    private String name;
    private String memberPattern;

    public static void main(String[] args) {
        System.out.println("hehe");
        String name = args[0];
        DataSetReader dr = new DataSetReader(name);
        try {
            Map<String, String> dataSets = dr.getDataSets();
            for (Map.Entry<String, String> entry : dataSets.entrySet()) {
                String entryname = entry.getKey();
                String content = entry.getValue();
                System.out.println("=====" + entryname + "==========");
                System.out.println(content);
                System.out.println();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public DataSetReader(String nm) {
        this.name = nm.toUpperCase();
        if (this.name.startsWith(SLASH_SLASH_PREFIX)) {
            this.name = this.name.substring(SLASH_SLASH_PREFIX.length());
        }
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getDataSets() throws IOException {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (this.name.matches(DSNAME_PATTERN)) {
            this.addMatchingDatasets(map);
        } else {
            Pattern mempat = Pattern.compile(DSNAME_WITH_MEMBER_OR_PATTERN);
            Matcher matcher = mempat.matcher(this.name);
            if (matcher.matches()) {
                this.name = matcher.group(1);
                this.memberPattern = matcher.group(2);
            }
            this.addDatasetOrPds(map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDatasetOrPds(Map<String, String> map) throws IOException {
        String ddname = this.allocDD();
        PdsDirectory pdsDir = null;
        if (this.memberPattern == null || this.memberPattern.indexOf(42) >= 0) {
            try {
                pdsDir = new PdsDirectory("//DD:" + ddname);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (pdsDir == null) {
            this.addDatasetOrMember(map, ddname, this.memberPattern);
            return;
        }
        Pattern memberRegex = null;
        if (this.memberPattern != null) {
            memberRegex = this.makeRegexPattern(this.memberPattern);
        }
        try {
            for (PdsDirectory.MemberInfo member : pdsDir) {
                String memberName = member.getName();
                if (memberRegex != null && !memberRegex.matcher(memberName).matches()) continue;
                this.addDatasetOrMember(map, ddname, memberName);
            }
        }
        finally {
            try {
                pdsDir.close();
            }
            catch (IOException iOException) {}
            this.freeDD(ddname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDatasetOrMember(Map<String, String> map, String ddname, String memberName) throws IOException {
        Reader reader = null;
        try {
            reader = this.openInputFile(ddname, memberName);
            BufferedReader bf = new BufferedReader(reader);
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = bf.readLine()) != null) {
                buffer.append(line).append("\n");
            }
            String datasetContent = buffer.toString();
            if (GenericHelper.isNullOrEmpty(datasetContent)) {
                throw new IllegalArgumentException(" [Error] Dataset " + this.name + " is empty.");
            }
            map.put(this.name, datasetContent);
        }
        finally {
            this.closeInputFile(reader);
            this.freeDD(ddname);
        }
    }

    private void addMatchingDatasets(Map<String, String> map) throws IOException {
        CatalogSearch catSearch = new CatalogSearch(this.name);
        catSearch.setEntryTypes("AH");
        catSearch.addFieldName("ENTNAME");
        catSearch.search();
        while (catSearch.hasNext()) {
            CatalogSearch.Entry entry = (CatalogSearch.Entry)catSearch.next();
            if (!entry.isDatasetEntry()) continue;
            CatalogSearchField field = entry.getField("ENTNAME");
            String dsn = field.getFString().trim();
            DataSetReader dataSetReader = new DataSetReader(dsn);
        }
    }

    private Pattern makeRegexPattern(String memberPattern) {
        StringBuffer patBuf = new StringBuffer("^");
        block4: for (int i = 0; i < memberPattern.length(); ++i) {
            char c = memberPattern.charAt(i);
            switch (c) {
                case '*': {
                    patBuf.append(".*");
                    continue block4;
                }
                case '$': {
                    patBuf.append("\\$");
                    continue block4;
                }
                default: {
                    patBuf.append(c);
                }
            }
        }
        patBuf.append('$');
        return Pattern.compile(patBuf.toString());
    }

    private void copyData(Reader reader, ZipOutputStream zipOutStream, String targetEncoding) throws IOException, UnsupportedEncodingException {
        int nRead;
        char[] cbuf = new char[65536];
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)zipOutStream, targetEncoding);
        while ((nRead = reader.read(cbuf)) != -1) {
            osw.write(cbuf, 0, nRead);
        }
        osw.flush();
    }

    private String allocDD() throws IOException {
        String ddname = null;
        if (this.name.startsWith(DD_PREFIX)) {
            ddname = this.name.substring(DD_PREFIX.length());
            return ddname;
        }
        try {
            ddname = ZFile.allocDummyDDName();
            ZFile.bpxwdyn((String)("alloc fi(" + ddname + ") da(" + this.name + ") shr reuse msg(2)"));
            return ddname;
        }
        catch (RcException rce) {
            this.freeDD(ddname);
            throw new IOException("Unable to allocate input dataset: " + this.name + " - " + (Object)((Object)rce));
        }
    }

    private void freeDD(String ddname) {
        if (ddname == null || this.name.startsWith(DD_PREFIX)) {
            return;
        }
        try {
            ZFile.bpxwdyn((String)("free fi(" + ddname + ")"));
        }
        catch (RcException rcException) {
            // empty catch block
        }
    }

    private Reader openInputFile(String ddname, String memberName) throws IOException {
        String sourceEncoding = ZUtil.getDefaultPlatformEncoding();
        String filename = "//DD:" + ddname + (memberName == null ? "" : "(" + memberName + ")");
        ZFile zFile = new ZFile(filename, "rt", 1);
        String actualFileName = zFile.getActualFilename();
        if (actualFileName != null) {
            this.name = actualFileName;
        }
        InputStream is = zFile.getInputStream();
        return new InputStreamReader(is, sourceEncoding);
    }

    private void closeInputFile(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

