/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.hfs;

import com.ibm.team.enterprise.automation.hfs.Messages;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestWriter;
import com.ibm.team.enterprise.automation.manifest.Resource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Move;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.taskdefs.condition.AntVersion;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarOutputStream;
import org.eclipse.osgi.util.NLS;

public class HFSUtil {
    public static final String HFS_SUBDIRECTORY = "HFS";
    private static final String XML_DECLARATION = "<?xml version=\"1.0\"?>\n";
    private static Boolean IS_Z_OS;
    private static Boolean POSIX_TAR_FORMAT;
    private static final Constructor tarOutputStreamConstructorAnt19x;
    private static final Constructor tarInputStreamConstructorAnt19x;

    public static boolean isZOS() {
        if (IS_Z_OS == null) {
            IS_Z_OS = "z/OS".equals(System.getProperty("os.name"));
        }
        return IS_Z_OS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeManifest(Manifest manifest, File destFile) throws Exception {
        if (HFSUtil.isZOS()) {
            String encoding = "IBM-1047";
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ManifestWriter.getInstance().write(os, encoding, manifest, true);
            try (FileOutputStream fos = null;){
                fos = new FileOutputStream(destFile);
                fos.write(XML_DECLARATION.getBytes(encoding));
                fos.write(os.toByteArray());
            }
        } else {
            ManifestWriter.getInstance().write(destFile, manifest);
        }
    }

    public static void createTar(List<FileSet> fileSets, File destFile, String tarSubDirectory, Project project) throws IOException {
        if (fileSets == null || fileSets.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String destDir = destFile.getParent();
        File tempTar = new File(destDir, "tempHFS.tar");
        tempTar.delete();
        Tar tarTask = (Tar)project.createTask("tar");
        tarTask.setDestFile(tempTar);
        Tar.TarLongFileMode mode = new Tar.TarLongFileMode();
        if (POSIX_TAR_FORMAT.booleanValue()) {
            mode.setValue("posix");
        } else {
            mode.setValue("gnu");
        }
        tarTask.setLongfile(mode);
        for (FileSet fileSet : fileSets) {
            tarTask.add((ResourceCollection)fileSet);
        }
        tarTask.execute();
        AntVersion version190 = new AntVersion();
        version190.setAtLeast("1.9.0");
        boolean createdAsEBCDIC = version190.eval();
        if (destFile.exists()) {
            File hfsTar = tempTar;
            tempTar = HFSUtil.joinTarFiles(destFile, tempTar, destDir, null, tarSubDirectory, "UTF-8", null);
            hfsTar.delete();
        } else if (createdAsEBCDIC || tarSubDirectory != null && !tarSubDirectory.isEmpty()) {
            File hfsTar = tempTar;
            tempTar = HFSUtil.joinTarFiles(null, tempTar, destDir, null, tarSubDirectory, null, null);
            hfsTar.delete();
        }
        HFSUtil.move(tempTar, destFile, project, false);
    }

    public static void move(File sourceFile, File targetFile, Project project, boolean verbose) {
        Move move = (Move)project.createTask("move");
        move.setFile(sourceFile);
        move.setTofile(targetFile);
        move.setVerbose(verbose);
        move.setOverwrite(true);
        move.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File joinTarFiles(File file1, File file2, String tempDir, String file1TarSubDirectory, String file2TarSubDirectory, String tar1Encoding, String tar2Encoding) throws IOException {
        File tempFile = new File(tempDir, "joined.tar");
        TarOutputStream tos = HFSUtil.createTarOutputStream(tempFile, "UTF-8");
        if (POSIX_TAR_FORMAT.booleanValue()) {
            tos.setLongFileMode(3);
        } else {
            tos.setLongFileMode(2);
        }
        try {
            if (file1 != null) {
                HFSUtil.append(file1, tos, file1TarSubDirectory, tar1Encoding);
            }
            if (file2 != null) {
                HFSUtil.append(file2, tos, file2TarSubDirectory, tar2Encoding);
            }
        }
        finally {
            if (tos != null) {
                try {
                    tos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(File tarFile, TarOutputStream out, String tarSubDirectory, String tarEncoding) throws IOException {
        if (tarSubDirectory != null && tarSubDirectory.isEmpty()) {
            tarSubDirectory = null;
        }
        if (tarSubDirectory != null && !tarSubDirectory.endsWith(File.separator)) {
            tarSubDirectory = tarSubDirectory + File.separator;
        }
        TarInputStream tis = HFSUtil.createTarInputStream(tarFile, tarEncoding);
        try {
            TarEntry next = tis.getNextEntry();
            while (next != null) {
                if (tarSubDirectory != null) {
                    next.setName(tarSubDirectory + next.getName());
                }
                out.putNextEntry(next);
                byte[] buf = new byte[8192];
                int count = 0;
                do {
                    out.write(buf, 0, count);
                } while ((count = tis.read(buf, 0, buf.length)) != -1);
                out.closeEntry();
                next = tis.getNextEntry();
            }
        }
        finally {
            if (tis != null) {
                try {
                    tis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean addContainersToFileSet(FileSet fileSet, List<Container> containers, boolean isInclude) {
        boolean addedInclude = false;
        for (Container container : HFSUtil.getHFSContainers(containers)) {
            Iterator<Resource> iter = container.getResourcesIterator();
            while (iter.hasNext()) {
                Resource resource = iter.next();
                String name = HFSUtil.getNormalizedPath(container, resource);
                if (isInclude) {
                    fileSet.createInclude().setName(name);
                    continue;
                }
                fileSet.createExclude().setName(name);
            }
            addedInclude = true;
        }
        return addedInclude;
    }

    public static String getNormalizedPath(Container container, Resource resource) {
        String path = container.getName() + File.separator + resource.getName();
        String delimiter = File.separator;
        if ("\\".equals(delimiter)) {
            delimiter = "\\\\";
        }
        String[] segments = path.split(delimiter);
        LinkedList<String> resolved = new LinkedList<String>();
        for (String segment : segments) {
            if (".".equals(segment)) continue;
            if ("..".equals(segment)) {
                if (resolved.isEmpty()) {
                    throw new BuildException(NLS.bind(Messages.HFSUtil_INVALID_RELATIVE_PATH, path));
                }
                resolved.removeLast();
                continue;
            }
            resolved.add(segment);
        }
        StringBuilder buf = new StringBuilder();
        for (String s : resolved) {
            if (buf.length() > 0 && buf.charAt(buf.length() - 1) != File.separatorChar) {
                buf.append(File.separatorChar);
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public static void collectFileInformation(String directory, String filename, Date timestamp, HashMap<String, HashSet<Resource>> directoryToResourceMapping, Project project, Resource originalResource) {
        File file = new File(directory + File.separator + filename);
        if (file.exists()) {
            if (file.isFile()) {
                Date resourceTimeStamp = new Date(file.lastModified());
                if (timestamp == null || timestamp.before(resourceTimeStamp)) {
                    HashSet<Object> resources;
                    Resource fileResource = originalResource == null ? new Resource() : new Resource(originalResource);
                    fileResource.setName(filename);
                    fileResource.setLastModifiedTimestamp(Long.toString(resourceTimeStamp.getTime()));
                    fileResource.setType("file");
                    if (directoryToResourceMapping.containsKey(directory)) {
                        resources = directoryToResourceMapping.get(directory);
                    } else {
                        resources = new HashSet();
                        directoryToResourceMapping.put(directory, resources);
                    }
                    resources.add(fileResource);
                }
            }
        } else {
            project.log(NLS.bind(Messages.HFSUtil_FILE_NOT_FOUND_INFO_MSG, directory + File.separator + filename));
        }
    }

    public static List<Container> getHFSContainers(List<Container> containers) {
        return HFSUtil.getHFSContainers(containers, false);
    }

    public static List<Container> getHFSContainers(List<Container> containers, boolean includeEmpty) {
        ArrayList<Container> hfsContainers = new ArrayList<Container>();
        for (Container container : containers) {
            if (!"directory".equalsIgnoreCase(container.getType()) || !includeEmpty && !container.getResourcesIterator().hasNext()) continue;
            hfsContainers.add(container);
        }
        return hfsContainers;
    }

    public static TarOutputStream createTarOutputStream(File file, String encoding) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        if (tarOutputStreamConstructorAnt19x != null) {
            try {
                return (TarOutputStream)tarOutputStreamConstructorAnt19x.newInstance(bos, encoding);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new TarOutputStream((OutputStream)bos);
    }

    private static TarInputStream createTarInputStream(File file, String encoding) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        if (tarInputStreamConstructorAnt19x != null) {
            try {
                return (TarInputStream)tarInputStreamConstructorAnt19x.newInstance(bis, encoding);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new TarInputStream((InputStream)bis);
    }

    static {
        Constructor input;
        Constructor output;
        POSIX_TAR_FORMAT = false;
        try {
            output = TarOutputStream.class.getConstructor(OutputStream.class, String.class);
        }
        catch (Exception e) {
            output = null;
        }
        try {
            input = TarInputStream.class.getConstructor(InputStream.class, String.class);
        }
        catch (Exception e) {
            input = null;
        }
        tarOutputStreamConstructorAnt19x = output;
        tarInputStreamConstructorAnt19x = input;
    }
}

