/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.common;

import com.ibm.urbancode.zos.deploy.common.XmlHelper;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ContainerMapperParser {
    private static final String MAP_NODE_NAME = "map";
    private static final String SOURCE_CONTAINER_NODE_NAME = "sourceContainer";
    private static final String TARGET_CONTAINER_NODE_NAME = "targetContainer";
    private static final String NAME_ATTRIBUTE = "name";

    public static Map<String, String> parseDeployRulerMapper(InputStream containerMapperInputStream) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        HashMap<String, String> rulerMapper = new HashMap<String, String>();
        XMLEventReader eventReader4RulerMaps = inputFactory.createXMLEventReader(containerMapperInputStream, "CP037");
        String currentSourceName = null;
        String currentTargetName = null;
        while (eventReader4RulerMaps.hasNext()) {
            EndElement endElement;
            String tagName;
            XMLEvent event = eventReader4RulerMaps.nextEvent();
            if (event.isStartElement()) {
                StartElement startElement = event.asStartElement();
                tagName = startElement.getName().getLocalPart().trim();
                if (tagName.equalsIgnoreCase(MAP_NODE_NAME)) {
                    currentSourceName = null;
                    currentTargetName = null;
                    continue;
                }
                if (tagName.equalsIgnoreCase(SOURCE_CONTAINER_NODE_NAME)) {
                    currentSourceName = XmlHelper.getAttributeValue(startElement, NAME_ATTRIBUTE);
                    continue;
                }
                if (!tagName.equalsIgnoreCase(TARGET_CONTAINER_NODE_NAME)) continue;
                currentTargetName = XmlHelper.getAttributeValue(startElement, NAME_ATTRIBUTE);
                continue;
            }
            if (!event.isEndElement() || !(tagName = (endElement = event.asEndElement()).getName().getLocalPart().trim()).equalsIgnoreCase(MAP_NODE_NAME) || null == currentSourceName || null == currentTargetName) continue;
            rulerMapper.put(currentSourceName, currentTargetName);
            currentSourceName = null;
            currentTargetName = null;
        }
        return rulerMapper;
    }
}

