/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.inputs;

import com.urbancode.air.plugin.inputs.InputsValidator;
import java.util.Properties;

public class CleanupBackupFilesInputs {
    public static final String RESOURCE_ID = "resourceId";
    public static final String COMPONENT_NAME = "componentName";
    public static final String VERSION_NAME = "versionName";
    public static final String DEPLOY_BASE_PATH = "deployBasePath";
    private final String resourceId;
    private final String componentName;
    private final String versionName;
    private final String deployBasePath;

    public CleanupBackupFilesInputs(Properties inputProperties) {
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
        this.componentName = inputProperties.getProperty(COMPONENT_NAME).trim();
        this.versionName = inputProperties.getProperty(VERSION_NAME).trim();
        this.deployBasePath = inputProperties.getProperty(DEPLOY_BASE_PATH).trim();
    }

    public void validateInputs() {
        InputsValidator.checkIfEmpty(this.deployBasePath, "Deployment Base Path");
        InputsValidator.checkIfEmpty(this.versionName, "Version Name");
        InputsValidator.checkIfEmpty(this.componentName, "Component Name");
        InputsValidator.checkIfEmpty(this.resourceId, "Resource Id");
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getDeployBasePath() {
        return this.deployBasePath;
    }
}

