/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.inputs;

import com.ibm.jzos.ZFile;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.urbancode.air.plugin.inputs.DirectoryNotFoundException;
import com.urbancode.air.plugin.inputs.HfsMappingHelper;
import com.urbancode.air.plugin.inputs.InputsValidator;
import com.urbancode.air.plugin.inputs.InvalidInputException;
import com.urbancode.air.plugin.inputs.MissingInputException;
import java.util.Properties;

public class DeployPackageInputs {
    public static final String RESOURCE_ID = "resourceId";
    public static final String COMPONENT_ID = "componentId";
    public static final String COMPONENT_NAME = "componentName";
    public static final String VERSION_NAME = "versionName";
    public static final String VERSION_ID = "versionId";
    public static final String VERSION_TYPE = "versionType";
    public static final String DEPLOY_BASE_PATH = "deployBasePath";
    public static final String TEMP_DSN_PREFIX = "tempDsnPrefix";
    public static final String PDS_MAPPING = "pdsMapping";
    public static final String CHECK_ACCESS = "checkAccess";
    public static final String ALLOW_CREATE_DATASET = "allowCreateDataset";
    public static final String ALLOW_CREATE_DIRECTORY = "allowCreateDirectory";
    public static final String VERSION_MERGE = "versionMerge";
    public static final String PRINT_LOGS = "printLogs";
    public static final String DELETE_CURRENT_CONTENTS = "deleteCurrentContents";
    public static final String INCREMENTAL_MODE = "incrementalMode";
    public static final String INCREMENTAL_MODE_FULL = "FULL";
    public static final String INCREMENTAL_MODE_INVENTORY = "INVENTORY";
    public static final String INCREMENTAL_MODE_RUNTIME = "RUNTIME";
    public static final String CONTAINER_FILTER = "containerFilter";
    public static final String BINDER_PATH = "binderPath";
    public static final String HFS_TARGET_DIR = "hfsTargetDir";
    public static final String DO_BACKUP = "doBackup";
    public static final String ENVIRONMENT_ID = "environmentId";
    private final String resourceId;
    private final String componentId;
    private final String componentName;
    private final String versionName;
    private final String versionId;
    private final String versionType;
    private final String deployBasePath;
    private final String tempDsnPrefix;
    private final String pdsMapping;
    private final boolean isCheckAccessEnabled;
    private final boolean isCreateDatasetAllowed;
    private final boolean isCreateDirectoryAllowed;
    private final boolean isMergedVersion;
    private final boolean isPrintLogsEnabled;
    private final boolean isDeleteCurrentContentsEnabled;
    private final String incrementalMode;
    private final String containerFilter;
    private final String binderPath;
    private final String hfsMapping;
    private final String environmentId;
    private boolean isBackupEnabled;
    private final boolean isOldHfsMappingFormat;

    public DeployPackageInputs(Properties inputProperties) {
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
        this.componentId = inputProperties.getProperty(COMPONENT_ID).trim();
        this.componentName = inputProperties.getProperty(COMPONENT_NAME).trim();
        this.versionName = inputProperties.getProperty(VERSION_NAME).trim();
        this.versionId = inputProperties.getProperty(VERSION_ID).trim();
        this.versionType = inputProperties.getProperty(VERSION_TYPE).trim();
        this.deployBasePath = inputProperties.getProperty(DEPLOY_BASE_PATH).trim();
        String passedTempDsnPrefix = inputProperties.getProperty(TEMP_DSN_PREFIX).trim();
        this.tempDsnPrefix = passedTempDsnPrefix.isEmpty() ? ZFile.getDefaultHLQ() : passedTempDsnPrefix;
        this.pdsMapping = inputProperties.getProperty(PDS_MAPPING).trim();
        this.incrementalMode = inputProperties.getProperty(INCREMENTAL_MODE).trim();
        this.containerFilter = inputProperties.getProperty(CONTAINER_FILTER).trim();
        this.binderPath = inputProperties.getProperty(BINDER_PATH).trim();
        this.environmentId = inputProperties.getProperty(ENVIRONMENT_ID).trim();
        String hfsTargetDir = inputProperties.getProperty(HFS_TARGET_DIR).trim();
        this.isOldHfsMappingFormat = !HfsMappingHelper.hasCommaSeparatedMapping(hfsTargetDir);
        this.hfsMapping = HfsMappingHelper.determineMapping(hfsTargetDir);
        this.isCheckAccessEnabled = Boolean.parseBoolean(inputProperties.getProperty(CHECK_ACCESS).trim());
        this.isCreateDatasetAllowed = Boolean.parseBoolean(inputProperties.getProperty(ALLOW_CREATE_DATASET).trim());
        this.isCreateDirectoryAllowed = Boolean.parseBoolean(inputProperties.getProperty(ALLOW_CREATE_DIRECTORY).trim());
        this.isMergedVersion = Boolean.parseBoolean(inputProperties.getProperty(VERSION_MERGE).trim());
        this.isPrintLogsEnabled = Boolean.parseBoolean(inputProperties.getProperty(PRINT_LOGS).trim());
        this.isDeleteCurrentContentsEnabled = Boolean.parseBoolean(inputProperties.getProperty(DELETE_CURRENT_CONTENTS).trim());
        this.isBackupEnabled = Boolean.parseBoolean(inputProperties.getProperty(DO_BACKUP).trim());
    }

    public void validateInputs() {
        InputsValidator.checkIfEmpty(this.resourceId, "Resource Id");
        InputsValidator.checkIfEmpty(this.componentId, "Component Id");
        InputsValidator.checkIfEmpty(this.componentName, "Component Name");
        InputsValidator.checkIfEmpty(this.versionName, "Version Name");
        InputsValidator.checkIfEmpty(this.versionId, "Version Id");
        this.validateVersionType();
        this.validateDeployBasePath();
        this.validateIncrementalMode();
        InputsValidator.checkIfEmpty(this.binderPath, "Binder API Path");
        InputsValidator.checkIfEmpty(this.environmentId, "Environment Id");
        if (this.isMergedVersion && this.hasContainerFilter()) {
            throw new InvalidInputException("Container Filters is not supported for a merged version");
        }
    }

    public void validateHFSInputs() {
        if (this.hfsMapping.isEmpty()) {
            throw new MissingInputException("Version contains HFS files. HFS Mapping is required.");
        }
        if (this.isBackupEnabled && this.isDeleteCurrentContentsEnabled) {
            throw new InvalidInputException("Backup of the target directory cannot be taken since we are deleting the target directory contents. Either the checkbox 'Delete the Target Directory contents' should be selected or the checkbox 'Backup for Rollback' checkbox should be selected. Please make the necessary changes and rerun deployment.");
        }
    }

    private void validateVersionType() {
        InputsValidator.checkIfEmpty(this.versionType, "Version Type");
        if (this.versionTypeIsNotFull() && this.versionTypeIsNotIncremental()) {
            throw new InvalidInputException("Invalid version type - " + this.versionType + ". Version Type must be either " + INCREMENTAL_MODE_FULL + " or " + "INCREMENTAL");
        }
    }

    private boolean versionTypeIsNotIncremental() {
        return !this.versionType.equalsIgnoreCase("INCREMENTAL");
    }

    private boolean versionTypeIsNotFull() {
        return !this.versionType.equalsIgnoreCase(INCREMENTAL_MODE_FULL);
    }

    private void validateDeployBasePath() {
        InputsValidator.checkIfEmpty(this.deployBasePath, "Deploy Base Path");
        if (FileHelper.isDirectoryNotExist(this.deployBasePath)) {
            throw new DirectoryNotFoundException(" [Error] Deploy Base Path " + this.deployBasePath + " does not exist.");
        }
    }

    private void validateIncrementalMode() {
        InputsValidator.checkIfEmpty(this.incrementalMode, "Delta Deploy");
        if (!(this.incrementalModeIsFull() || this.incrementalModeIsInventory() || this.incrementalModeIsRuntime())) {
            throw new InvalidInputException("Invalid delta deploy - " + this.incrementalMode + ". Valid delta deploy values are " + INCREMENTAL_MODE_FULL + "/" + INCREMENTAL_MODE_INVENTORY + "/" + INCREMENTAL_MODE_RUNTIME);
        }
    }

    public boolean incrementalModeIsRuntime() {
        return this.incrementalMode.equalsIgnoreCase(INCREMENTAL_MODE_RUNTIME);
    }

    public boolean incrementalModeIsInventory() {
        return this.incrementalMode.equalsIgnoreCase(INCREMENTAL_MODE_INVENTORY);
    }

    public boolean incrementalModeIsFull() {
        return this.incrementalMode.equalsIgnoreCase(INCREMENTAL_MODE_FULL);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getVersionType() {
        return this.versionType;
    }

    public String getDeployBasePath() {
        return this.deployBasePath;
    }

    public boolean isCheckAccessEnabled() {
        return this.isCheckAccessEnabled;
    }

    public String getPdsMapping() {
        return this.pdsMapping;
    }

    public String getTempDsnPrefix() {
        return this.tempDsnPrefix;
    }

    public boolean isCreateDirectoryAllowed() {
        return this.isCreateDirectoryAllowed;
    }

    public boolean isCreateDatasetAllowed() {
        return this.isCreateDatasetAllowed;
    }

    public boolean isMergedVersion() {
        return this.isMergedVersion;
    }

    public boolean isPrintLogsEnabled() {
        return this.isPrintLogsEnabled;
    }

    public boolean isDeleteCurrentContentsEnabled() {
        return this.isDeleteCurrentContentsEnabled;
    }

    public String getContainerFilter() {
        return this.containerFilter;
    }

    public String getBinderPath() {
        return this.binderPath;
    }

    public boolean hasContainerFilter() {
        return !this.containerFilter.isEmpty();
    }

    public String getHfsMapping() {
        return this.hfsMapping;
    }

    public boolean isOldHfsMappingFormat() {
        return this.isOldHfsMappingFormat;
    }

    public boolean isBackupEnabled() {
        return this.isBackupEnabled;
    }

    public void skipBackup() {
        this.isBackupEnabled = false;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }
}

