/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.jzos.PdsDirectory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BackupMVS
extends Exception {
    private static final int ERR_REC = 8;
    private String CREATED_TAG = "created";
    private String DELETED_TAG = "deleted";
    private String UPDATED_TAG = "updated";
    private String CONTAINER_TAG = "container";
    private String RESOURCE_TAG = "resource";
    private String PROPERTY = "property";
    private String CHANGE_TYPE = "changeType";
    private String ADD_TYPE = "ADD";
    private String PDS_TYPE = "PDS";
    private String SEQUENTIAL_TYPE = "sequential";
    private String CONTAINER_TYPE = "type";
    private String CONTAINER_NAME = "name";
    private String CONTAINER_DEPLOY_TYPE = "deployType";
    private String MAP_TAG = "map";
    private String MAP_TYPE = "type";
    private String SOURCE_CONTAINER_NAME = "name";
    private String TARGET_CONTAINER_NAME = "name";
    private String RESOURCE_NAME = "name";
    private String RESOURCE_LAST_MODIFIED_TIMESTAMP = "lastModifiedTimestamp";
    private String RESOURCE_TYPE = "type";
    private static final String TWO_SLASHES_AND_SINGLE_QUOTE = "//";
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTES = "\"";
    private static final String OPEN_PARANTHESIS = "(";
    private static final String CLOSE_PARANTHESIS = ")";
    private static final String SINGLE_SPACE = " ";
    private static final String SEMI_COLON = ";";
    private static final String COPY_CMD = "cp ";
    private static final String COPY_OPTIONS_EXEC = "-X ";
    private static final String COPY_OPTIONS_BIN = "-B ";
    private static final String COPY_OPTIONS_TXT = "-T ";
    private static final String RM_CMD = "rm -r ";
    private String manifestFilePath = null;
    private String componentVersionWorkingDir = null;
    private String containerMapperFilePath = null;
    private String verbose = null;
    private String backupName = null;
    private String TEMP_FILE_NAME = "backup_temp.sh";
    private String deltaDeployedName = "deltaDeployed.xml";
    PdsDirectory dir = null;
    PdsDirectory.MemberInfo memberInfo = null;
    PdsDirectory.MemberInfo.Statistics pdsStatistics = null;
    List<String> memberList = new ArrayList<String>();
    List<Date> memberModDate = new ArrayList<Date>();
    List<String> memberModUserid = new ArrayList<String>();
    String copyOptions = " ";
    String delCommand = "rm -r ";
    String tarCommand;
    HashMap<String, String> PDSMapper = new HashMap();

    public BackupMVS(String manifestFilePath, String componentVersionWorkingDir, String containerMapperFilePath, String backupName) throws Exception {
        this.manifestFilePath = manifestFilePath;
        this.componentVersionWorkingDir = componentVersionWorkingDir;
        this.containerMapperFilePath = containerMapperFilePath;
        this.backupName = backupName;
        System.out.println("Manifest file : " + manifestFilePath);
        System.out.println("Component version working directory : " + componentVersionWorkingDir);
        System.out.println("Container Mapper file : " + containerMapperFilePath);
        System.out.println("Backup file : " + backupName);
    }

    public void BackupTargetFiles() throws Exception, IOException {
        File packageManifest;
        try {
            packageManifest = new File(this.manifestFilePath);
            File containerMapper = new File(this.containerMapperFilePath);
            File backupDirectory = new File(this.componentVersionWorkingDir);
        }
        catch (NullPointerException e) {
            throw new Exception(e.getMessage(), e);
        }
        File commandFile = new File(this.componentVersionWorkingDir + File.separator + this.TEMP_FILE_NAME);
        BufferedWriter commandWriter = new BufferedWriter(new FileWriter(commandFile.getAbsolutePath()));
        commandWriter.append("#!/bin/sh");
        commandWriter.newLine();
        this.tarCommand = "tar -cf " + this.backupName + SINGLE_SPACE;
        File deltaDeployedXML = new File(this.componentVersionWorkingDir + File.separator + this.deltaDeployedName);
        deltaDeployedXML.createNewFile();
        try {
            File backupZip = new File(this.componentVersionWorkingDir + File.separator + this.backupName);
            boolean backupExists = backupZip.exists();
            if (backupExists) {
                backupZip.delete();
            }
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage(), exception);
        }
        try {
            DocumentBuilderFactory docBldrFactory = DocumentBuilderFactory.newInstance();
            docBldrFactory.setIgnoringElementContentWhitespace(true);
            docBldrFactory.setCoalescing(true);
            docBldrFactory.setIgnoringComments(true);
            DocumentBuilder docBldr = docBldrFactory.newDocumentBuilder();
            Document packageManifestParser = docBldr.parse(packageManifest);
            this.readContainerMapperFile();
            System.out.println("mapping done");
            Document deltaDeployed = docBldr.newDocument();
            Element root = deltaDeployed.createElement("manifest");
            deltaDeployed.appendChild(root);
            Attr attrForManifest = deltaDeployed.createAttribute("type");
            attrForManifest.setValue("MANIFEST_REPORT");
            root.setAttributeNode(attrForManifest);
            Element created = deltaDeployed.createElement("created");
            Element updated = deltaDeployed.createElement("updated");
            Element deleted = deltaDeployed.createElement("deleted");
            root.appendChild(created);
            root.appendChild(updated);
            root.appendChild(deleted);
            NodeList createdNodes = packageManifestParser.getElementsByTagName(this.CREATED_TAG);
            NodeList containerNodes = packageManifestParser.getElementsByTagName(this.CONTAINER_TAG);
            NodeList deletedNodes = packageManifestParser.getElementsByTagName(this.DELETED_TAG);
            NodeList[] nodeListArray = new NodeList[]{createdNodes, containerNodes, deletedNodes};
            System.out.println("going to loop");
            Transformer tFormer = TransformerFactory.newInstance().newTransformer();
            tFormer.setOutputProperty("encoding", "IBM-1047");
            tFormer.setOutputProperty("method", "xml");
            tFormer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(deltaDeployed);
            StreamResult result = new StreamResult(deltaDeployedXML);
            tFormer.transform(source, result);
            if (this.delCommand != RM_CMD) {
                commandWriter.append(this.tarCommand);
                commandWriter.newLine();
                this.addCommandCheck(commandWriter);
                commandWriter.newLine();
                this.addCommandCheck(commandWriter);
                commandWriter.append(this.delCommand);
                commandWriter.newLine();
                this.addCommandCheck(commandWriter);
                commandWriter.newLine();
            }
            commandWriter.flush();
            commandWriter.close();
            this.executeTempFile();
        }
        catch (ParserConfigurationException pce) {
            System.out.println(pce.getMessage());
            System.exit(8);
        }
        catch (IOException ioexception) {
            System.out.println(ioexception.getMessage());
            System.exit(8);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(8);
        }
    }

    void copyAttributes(Node childNode, Element Tag, boolean deepCopy) {
        NamedNodeMap childNodeAttributes = childNode.getAttributes();
        for (int i = 0; i < childNodeAttributes.getLength(); ++i) {
            Attr node = (Attr)childNodeAttributes.item(i);
            Tag.setAttributeNode((Attr)node.cloneNode(deepCopy));
        }
    }

    private void addCommandCheck(BufferedWriter commandWriter) {
        try {
            commandWriter.append("if [ $? != 0 ] ; then");
            commandWriter.newLine();
            commandWriter.append("exit 99");
            commandWriter.newLine();
            commandWriter.append("fi");
            commandWriter.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addCommandCheckIgnore(BufferedWriter commandWriter) {
        try {
            commandWriter.append("if [ $? != 0 ] ; then");
            commandWriter.newLine();
            commandWriter.append("echo sequential file backup failed. Continuing the process as it might be because of file not exists");
            commandWriter.newLine();
            commandWriter.append("fi");
            commandWriter.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void executeTempFile() {
        File workDir = new File(this.componentVersionWorkingDir);
        File tempFile = new File(this.componentVersionWorkingDir + File.separator + this.TEMP_FILE_NAME);
        try {
            int c;
            String[] cmdArgs = new String[]{"chmod", "+x", tempFile.getAbsolutePath()};
            ProcessBuilder pb = new ProcessBuilder(cmdArgs);
            pb.directory(workDir);
            pb.redirectErrorStream(true);
            Process chmod = pb.start();
            InputStream iStream = chmod.getInputStream();
            while ((c = iStream.read()) != -1) {
                System.out.print((char)c);
            }
            chmod.getOutputStream().close();
            chmod.waitFor();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(8);
        }
        try {
            String line;
            int exitCode = -1;
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.directory(workDir);
            processBuilder.command("./" + this.TEMP_FILE_NAME);
            Process process = processBuilder.start();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream(), "IBM-1047"));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream(), "IBM-1047"));
            while ((line = stdInput.readLine()) != null) {
                System.out.println(line);
            }
            stdInput.close();
            while ((line = stdError.readLine()) != null) {
                System.out.println(line);
            }
            stdError.close();
            process.waitFor();
            exitCode = process.exitValue();
            if (exitCode > 0) {
                System.out.println("Copy from Datasets failed with exit code " + exitCode);
                while ((line = stdError.readLine()) != null) {
                    System.out.println(line);
                }
                System.exit(8);
            }
            System.out.println("Copy to temp datasets success");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(8);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(8);
        }
    }

    private void readContainerMapperFile() {
        File inputFile = new File(this.containerMapperFilePath);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputFile);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("map");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                NodeList sourceContainerList = eElement.getElementsByTagName("sourceContainer");
                NodeList targetContainerList = eElement.getElementsByTagName("targetContainer");
                String sourceContainerName = new String();
                String targetContainerName = new String();
                for (int count = 0; count < sourceContainerList.getLength(); ++count) {
                    Node node1 = sourceContainerList.item(count);
                    if (node1.getNodeType() == 1) {
                        Element element = (Element)node1;
                        sourceContainerName = element.getAttribute("name");
                    }
                    Node node2 = targetContainerList.item(count);
                    if (node2.getNodeType() == 1) {
                        Element element = (Element)node2;
                        targetContainerName = element.getAttribute("name");
                    }
                    this.PDSMapper.put(sourceContainerName, targetContainerName);
                }
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

