/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.common.util.MVSHelper;
import com.ibm.urbancode.zos.dataset.alloc.AllocateCommand;
import com.ibm.urbancode.zos.dataset.alloc.AllocateCommandBuilder;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.urbancode.air.plugin.inputs.AllocateDatasetInputs;
import java.util.Properties;

public class AllocateDataset {
    public static final String OUTPUT_PROPERTY_DATASET_NAME = "DatasetName";
    private final Properties inputProperties;
    private final Properties outputProperties;

    public AllocateDataset(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            AllocateDatasetInputs pluginInputs = new AllocateDatasetInputs(this.inputProperties);
            pluginInputs.validateInputs();
            if (pluginInputs.isDeleteDatasetEnabled()) {
                DatasetHelper.deleteDataset(pluginInputs.getDatasetName());
            }
            AllocateCommand allocateCommand = this.getAllocateCommand(pluginInputs);
            allocateCommand.execute();
            String actualDatasetName = DatasetHelper.isGDGDatasetWithReference(pluginInputs.getDatasetName()) ? MVSHelper.getGDGNameAssignedToDD(allocateCommand.getDDName()) : pluginInputs.getDatasetName();
            allocateCommand.freeDDName();
            System.out.println(" [INFO] Dataset " + actualDatasetName + " is created.");
            this.outputProperties.put(OUTPUT_PROPERTY_DATASET_NAME, actualDatasetName);
            return 0;
        }
        catch (RuntimeException runtimeException) {
            System.out.println(" [Error] " + runtimeException.getMessage());
        }
        catch (ZFileException zFileException) {
            zFileException.printStackTrace();
        }
        return 1;
    }

    private AllocateCommand getAllocateCommand(AllocateDatasetInputs pluginInputs) {
        AllocateCommandBuilder allocateCommandBuilder = new AllocateCommandBuilder(pluginInputs.getDatasetName()).withVolumeSerial(pluginInputs.getVolumeSerial()).withSpace(pluginInputs.getPrimaryQuantity(), pluginInputs.getSecondaryQuantity()).withSpaceUnit(pluginInputs.getSpaceUnit(), pluginInputs.getRecordLength()).withBlockSize(pluginInputs.getBlockSize()).withAvgRec(pluginInputs.getAverageRECUnit()).withDirectoryBlocks(pluginInputs.getDirectoryBlocks()).withRecordFormat(pluginInputs.getRecordFormat()).withDatasetType(pluginInputs.getDataSetNameType());
        if (this.isSpaceUnitNotBlocks(pluginInputs.getSpaceUnit()) || this.isRecordFormatNotUndefined(pluginInputs.getRecordFormat())) {
            allocateCommandBuilder = allocateCommandBuilder.withRecordLength(pluginInputs.getRecordLength());
        }
        allocateCommandBuilder = allocateCommandBuilder.withReuseNewCatalogDisposition();
        return allocateCommandBuilder.build();
    }

    private boolean isSpaceUnitNotBlocks(String spaceUnit) {
        return !spaceUnit.equals("BLKS");
    }

    private boolean isRecordFormatNotUndefined(String recordFormat) {
        return !recordFormat.equals("U");
    }
}

