/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.filter;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SoftCachingFilter
implements Filter {
    private static Logger logger = Logger.getLogger(SoftCachingFilter.class);
    private static Map<String, Date> file2modifiedDate = new HashMap<String, Date>();
    private final DateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private FilterConfig filterConfig;

    public SoftCachingFilter() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String uri = httpRequest.getRequestURI();
        String realPath = this.filterConfig.getServletContext().getRealPath(uri);
        if (!file2modifiedDate.containsKey(realPath)) {
            File file = new File(realPath);
            if (file.exists()) {
                file2modifiedDate.put(realPath, new Date(file.lastModified()));
            } else {
                file2modifiedDate.put(realPath, new Date());
            }
        }
        Date modifiedDate = file2modifiedDate.get(realPath);
        httpResponse.setHeader("Last-Modified", this.dateFormat.format(modifiedDate));
        httpResponse.setHeader("Cache-Control", "public");
        filterChain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        logger.info("Filter initialized");
    }

    public void destroy() {
        logger.info("Filter destroyed");
    }
}

