/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.packaging.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.commons.lang3.StringUtils;

public final class AgentIspfHelper {
    private static final String CONF_DIRECTORY = "conf";
    private static final String TOOLKIT_DIRECTORY = "toolkit";
    private static final String ISPZXENV_FILE = "ISPZXENV";
    private static final String WORKAREA_DIRECTORY = "WORKAREA";
    private static final String DOT_LAST_FILE_EXTENSION = ".last";
    private static final String USER_NAME = System.getProperty("user.name");
    private static final String EQUALS_OPERATOR = "=";
    private static final String STRIP_CHARS = " '\"";
    private static final String CGI_ISPWORK_REGEX = "CGI_ISPWORK(\\s)*(=).+";
    private static final String AGENT_HOME = "AGENT_HOME";

    private AgentIspfHelper() {
    }

    public static void checkDirectoryFilePermissions() {
        String ispfDirPath = null;
        File ispzxenvFile = new File(System.getenv(AGENT_HOME).trim() + File.separator + CONF_DIRECTORY + File.separator + TOOLKIT_DIRECTORY + File.separator + ISPZXENV_FILE);
        if (ispzxenvFile.isFile()) {
            ispfDirPath = AgentIspfHelper.determineIspfDirFromIspzxenvFile(ispzxenvFile);
        } else {
            System.out.println("WARNING: " + ispzxenvFile + " does not exist for ISPF Gateway");
        }
        if (ispfDirPath != null) {
            AgentIspfHelper.validateIspfFilePermissions(ispfDirPath);
        } else {
            System.out.println("WARNING: Couldn't able to determine ISPF path from file " + ispzxenvFile + " for permissions check");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String determineIspfDirFromIspzxenvFile(File ispzxenvFile) {
        try (BufferedReader reader = new BufferedReader(new FileReader(ispzxenvFile));){
            String line;
            do {
                if ((line = reader.readLine()) == null) return null;
            } while (!(line = line.trim()).matches(CGI_ISPWORK_REGEX));
            String cgiIspWorkValue = line.substring(line.indexOf(EQUALS_OPERATOR) + 1);
            String string = StringUtils.strip((String)cgiIspWorkValue, (String)STRIP_CHARS);
            return string;
        }
        catch (Exception e) {
            System.out.println("WARNING: Exception while reading file " + ispzxenvFile);
        }
        return null;
    }

    private static void validateIspfFilePermissions(String ispfDirPath) {
        File ispfDir = new File(ispfDirPath);
        File ispfWorkAreaDir = new File(ispfDir + File.separator + WORKAREA_DIRECTORY);
        File ispfLastFile = new File(ispfWorkAreaDir + File.separator + USER_NAME + DOT_LAST_FILE_EXTENSION);
        if (ispfLastFile.isFile() && !ispfLastFile.canWrite()) {
            System.out.println("WARNING: User '" + USER_NAME + "' do not have write permission to file " + ispfLastFile);
        }
        if (ispfWorkAreaDir.isDirectory() && !ispfWorkAreaDir.canWrite()) {
            System.out.println("WARNING : User '" + USER_NAME + "' do not have write permission to directory " + ispfWorkAreaDir);
        }
        if (ispfDir.isDirectory() && !ispfDir.canWrite()) {
            System.out.println("WARNING : User '" + USER_NAME + "' do not have write permission to directory " + ispfDir);
        }
    }
}

