/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.common;

import com.ibm.urbancode.zos.deploy.common.ContainerMapperParser;
import com.ibm.urbancode.zos.deploy.common.DataSet;
import com.ibm.urbancode.zos.deploy.common.Member;
import com.ibm.urbancode.zos.deploy.common.PackageManifestParser;
import com.ibm.urbancode.zos.deploy.common.RollbackManifestParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class DeploymentResultHelper {
    private static final String PACKAGE_MANIFEST_XML = "packageManifest.xml";
    private static final String DEPLOY_DIRECTORY = "deploy";
    private static final String CONTAINER_MAPPER_XML = "containerMapper.xml";
    private static final String ROLLBACK_MANIFEST_XML = "rollbackManifest.xml";
    private static final String DIRECTORY = "directory";

    public static Set<DataSet> getDeployedDataSets(String deployBasePath, String resourceId, String componentName, String versionName) throws IOException, XMLStreamException {
        Set<DataSet> deployedDatasets;
        try (InputStream packageManifestInputStream = Files.newInputStream(Paths.get(DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, PACKAGE_MANIFEST_XML, true), new String[0]), new OpenOption[0]);){
            deployedDatasets = PackageManifestParser.parseDeployedDatasets(packageManifestInputStream);
        }
        Map<String, String> rulerMapper = DeploymentResultHelper.getDeployContainerMapper(deployBasePath, resourceId, componentName, versionName);
        DeploymentResultHelper.updateTargetDatasetUsingMapper(deployedDatasets, rulerMapper);
        return deployedDatasets;
    }

    private static void updateTargetDatasetUsingMapper(Set<DataSet> deployedDatasets, Map<String, String> rulerMapper) {
        for (DataSet currentDeployedDataSet : deployedDatasets) {
            if (!DeploymentResultHelper.isNotDirectoryType(currentDeployedDataSet)) continue;
            String targetDsName = rulerMapper.get(currentDeployedDataSet.getName());
            currentDeployedDataSet.setName(targetDsName);
            if (currentDeployedDataSet.getMembers() == null) continue;
            for (Member member : currentDeployedDataSet.getMembers()) {
                member.setDataSetName(targetDsName);
            }
        }
    }

    private static boolean isNotDirectoryType(DataSet currentDeployedDataSet) {
        return !DIRECTORY.equals(currentDeployedDataSet.getType());
    }

    public static HashMap<String, Set<DataSet>> getRollbackStructure(String deployBasePath, String resourceId, String componentName, String versionName) throws IOException, XMLStreamException {
        HashMap<String, Set<DataSet>> rollbackHashMap;
        try (InputStream rollbackInputStream = Files.newInputStream(Paths.get(DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, ROLLBACK_MANIFEST_XML, true), new String[0]), new OpenOption[0]);){
            rollbackHashMap = RollbackManifestParser.parseDataFromRollbackXml(rollbackInputStream);
        }
        return rollbackHashMap;
    }

    public static Set<DataSet> getNotDeployedDataSets(String manifestFilePath) throws IOException, XMLStreamException {
        Set<DataSet> notDeployedDatasets;
        try (InputStream packageManifestInputStream = Files.newInputStream(Paths.get(manifestFilePath, new String[0]), new OpenOption[0]);){
            notDeployedDatasets = PackageManifestParser.parseDeployedDatasets(packageManifestInputStream);
        }
        return notDeployedDatasets;
    }

    public static boolean checkVersionDeployed(String deployBasePath, String resourceId, String componentName, String versionName) {
        String packageManifestFilePath = DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, PACKAGE_MANIFEST_XML, false);
        File packageManifestFile = new File(packageManifestFilePath);
        return packageManifestFile.exists();
    }

    public static Set<DataSet> getOnlyDeployedContainers(Set<DataSet> containers) {
        HashSet<DataSet> onlyDeployedContainers = new HashSet<DataSet>();
        for (DataSet container : containers) {
            if (container.isDelete()) continue;
            onlyDeployedContainers.add(container);
        }
        return onlyDeployedContainers;
    }

    public static Set<DataSet> getOnlyDeletedContainers(Set<DataSet> containers) {
        HashSet<DataSet> onlyDeletedContainers = new HashSet<DataSet>();
        for (DataSet container : containers) {
            if (!container.isDelete()) continue;
            onlyDeletedContainers.add(container);
        }
        return onlyDeletedContainers;
    }

    private static Map<String, String> getDeployContainerMapper(String deployBasePath, String resourceId, String componentName, String versionName) throws IOException, XMLStreamException {
        Map<String, String> deployContainerMapper = new HashMap<String, String>();
        String containerMapperFilePath = DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, CONTAINER_MAPPER_XML, false);
        File file = new File(containerMapperFilePath);
        if (!file.exists() || !file.isFile()) {
            return deployContainerMapper;
        }
        try (InputStream containerMapperInputStream = Files.newInputStream(Paths.get(DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, CONTAINER_MAPPER_XML, false), new String[0]), new OpenOption[0]);){
            deployContainerMapper = ContainerMapperParser.parseDeployRulerMapper(containerMapperInputStream);
        }
        return deployContainerMapper;
    }

    private static String getDeployMetaFilePath(String deployBasePath, String resourceId, String componentName, String versionName, String fileName, boolean checkExist) {
        File file;
        String metaFilePath = deployBasePath + File.separator + DEPLOY_DIRECTORY + File.separator + resourceId + File.separator + componentName + File.separator + versionName + File.separator + fileName;
        if (!(!checkExist || (file = new File(metaFilePath)).exists() && file.isFile())) {
            throw new IllegalArgumentException(metaFilePath + " not found, please make sure the version has been successfully deployed");
        }
        return metaFilePath;
    }
}

