/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.team.enterprise.deployment.toolkit.manifest.AbstractGenerateManifest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenerateRollbackManifest
extends AbstractGenerateManifest {
    private static final String CREATED_TAG = "created";
    private static final String DELETED_TAG = "deleted";
    private static final String UPDATED_TAG = "updated";
    private static final String TRANSIENT = "_tmp";
    private static final String CONTAINER_TAG = "container";
    private static final String RESOURCE_TAG = "resource";
    private static final String CHANGE_TYPE = "changeType";
    private static final String ADD_TYPE = "ADD";
    private static final String DELETE_TYPE = "DELETE";
    private static final String SIZE_TYPE = "size";
    private static final String LAST_MODIFIED_TIME_TYPE = "lastModifiedTimestamp";
    private static final String WORK_ITEM_NUMBER_TYPE = "workItemId";
    private static final String WORK_ITEM_UUID_TYPE = "workItemUUID";
    private static final String MISSING_ATTRIBUTE = "missing";
    private static final String MISSING_TRUE = "true";

    public GenerateRollbackManifest(String deltaDeployManifestPath, String rollbackManifestPath) throws Exception {
        super(deltaDeployManifestPath, rollbackManifestPath);
    }

    public void generate() throws Exception {
        NodeList deletedTmpNodes;
        NodeList updatedNodes;
        NodeList deletedNodes;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setCoalescing(true);
        documentBuilderFactory.setIgnoringComments(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(this.inputManifest);
        NodeList createdNodes = document.getElementsByTagName(CREATED_TAG);
        if (createdNodes.getLength() > 0) {
            document.renameNode(createdNodes.item(0), null, "deleted_tmp");
            NodeList createdChildNodes = createdNodes.item(0).getChildNodes();
            for (int i = 0; i < createdChildNodes.getLength(); ++i) {
                Node container = createdChildNodes.item(i);
                if (!container.getNodeName().equals(CONTAINER_TAG)) continue;
                for (int j = 0; j < container.getAttributes().getLength(); ++j) {
                    NamedNodeMap attributes = container.getAttributes();
                    Node type = attributes.getNamedItem(CHANGE_TYPE);
                    if (!type.getNodeValue().equals(ADD_TYPE)) continue;
                    type.setNodeValue(DELETE_TYPE);
                }
                this.cleanUpAttributes(container);
            }
        }
        if ((deletedNodes = document.getElementsByTagName(DELETED_TAG)).getLength() > 0) {
            int i;
            NodeList deletedChildNodes = deletedNodes.item(0).getChildNodes();
            for (i = 0; i < deletedChildNodes.getLength(); ++i) {
                Node container = deletedChildNodes.item(i);
                if (!container.getNodeName().equals(CONTAINER_TAG)) continue;
                if (container.getAttributes().getNamedItem(MISSING_ATTRIBUTE) != null && MISSING_TRUE.equals(container.getAttributes().getNamedItem(MISSING_ATTRIBUTE).getNodeValue())) {
                    deletedNodes.item(0).removeChild(container);
                    continue;
                }
                NodeList resources = container.getChildNodes();
                for (int j = 0; j < resources.getLength(); ++j) {
                    Node resource = resources.item(j);
                    if (!resource.getNodeName().equals(RESOURCE_TAG) || resource.getAttributes().getNamedItem(MISSING_ATTRIBUTE) == null || !MISSING_TRUE.equals(resource.getAttributes().getNamedItem(MISSING_ATTRIBUTE).getNodeValue())) continue;
                    container.removeChild(resource);
                }
            }
            deletedChildNodes = deletedNodes.item(0).getChildNodes();
            for (i = 0; i < deletedChildNodes.getLength(); ++i) {
                Node container = deletedChildNodes.item(i);
                if (!container.getNodeName().equals(CONTAINER_TAG)) continue;
                for (int j = 0; j < container.getAttributes().getLength(); ++j) {
                    NamedNodeMap attributes = container.getAttributes();
                    Node type = attributes.getNamedItem(CHANGE_TYPE);
                    type.setNodeValue(ADD_TYPE);
                }
                this.cleanUpAttributes(container);
            }
            document.renameNode(deletedNodes.item(0), null, CREATED_TAG);
        }
        if ((updatedNodes = document.getElementsByTagName(UPDATED_TAG)).getLength() > 0) {
            NodeList updatedChildNodes = updatedNodes.item(0).getChildNodes();
            for (int i = 0; i < updatedChildNodes.getLength(); ++i) {
                Node container = updatedChildNodes.item(i);
                if (!container.getNodeName().equals(CONTAINER_TAG)) continue;
                this.cleanUpAttributes(container);
            }
        }
        if ((deletedTmpNodes = document.getElementsByTagName("deleted_tmp")).getLength() > 0) {
            document.renameNode(deletedTmpNodes.item(0), null, DELETED_TAG);
        }
        this.saveRollbackFile(document);
        this.convertToDefaultEncoding();
    }

    private void convertToDefaultEncoding() {
        try {
            String line;
            File tempFile = new File(this.outputManifest.getAbsolutePath() + ".tmp");
            BufferedReader br = new BufferedReader(new FileReader(this.outputManifest));
            PrintWriter pw = new PrintWriter(new FileWriter(tempFile));
            while ((line = br.readLine()) != null) {
                pw.println(line);
                pw.flush();
            }
            pw.close();
            br.close();
            if (!this.outputManifest.delete()) {
                return;
            }
            tempFile.renameTo(this.outputManifest);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private void cleanUpAttributesOnResource(NamedNodeMap attributes) {
        Node workItemUUID;
        Node workItemNumber;
        Node lastModifiedTime;
        Node size = attributes.getNamedItem(SIZE_TYPE);
        if (size != null) {
            attributes.removeNamedItem(SIZE_TYPE);
        }
        if ((lastModifiedTime = attributes.getNamedItem(LAST_MODIFIED_TIME_TYPE)) != null) {
            attributes.removeNamedItem(LAST_MODIFIED_TIME_TYPE);
        }
        if ((workItemNumber = attributes.getNamedItem(WORK_ITEM_NUMBER_TYPE)) != null) {
            attributes.removeNamedItem(WORK_ITEM_NUMBER_TYPE);
        }
        if ((workItemUUID = attributes.getNamedItem(WORK_ITEM_UUID_TYPE)) != null) {
            attributes.removeNamedItem(WORK_ITEM_UUID_TYPE);
        }
    }

    private void cleanUpAttributes(Node container) {
        NodeList resources = container.getChildNodes();
        for (int i = 0; i < resources.getLength(); ++i) {
            Node resource = resources.item(i);
            if (!resource.getNodeName().equals(RESOURCE_TAG)) continue;
            this.cleanUpAttributesOnResource(resource.getAttributes());
        }
    }
}

