/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.common.util.TsoIspfHelper;
import com.urbancode.air.plugin.inputs.TsoIspfInputs;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TsoIspf {
    private static final String SERVICE_TYPE_ISPF = "ISPF";
    private final Properties inputProperties;

    public TsoIspf(Properties inputProperties, Properties ignoredOutputProperties) {
        this.inputProperties = inputProperties;
    }

    public int execute() {
        try {
            TsoIspfInputs pluginInputs = new TsoIspfInputs(this.inputProperties);
            TsoIspfHelper tsoIspfHelper = new TsoIspfHelper(pluginInputs.getIspfGatewayPath(), pluginInputs.isReuseSessionSet(), pluginInputs.getServiceType(), pluginInputs.getIspProf());
            boolean isCommandFailed = false;
            try (BufferedReader reader = new BufferedReader(new StringReader(pluginInputs.getCommands()));){
                String commandLine;
                while ((commandLine = reader.readLine()) != null) {
                    if (this.isLineNotEmpty(commandLine)) {
                        TsoIspf.runCommand(commandLine, tsoIspfHelper, pluginInputs.isShowLogSet());
                        boolean bl = isCommandFailed = tsoIspfHelper.getReturnCode() > 0;
                    }
                    if (!isCommandFailed || !pluginInputs.isStopOnFailSet()) continue;
                    this.printSkippedCommands(reader);
                }
            }
            if (isCommandFailed) {
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            System.out.println("Error executing TSO/ISPF command: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }

    private boolean isLineNotEmpty(String line) {
        return !line.trim().isEmpty();
    }

    private static void runCommand(String command, TsoIspfHelper tsoIspfHelper, boolean isShowLogSet) throws IOException, ParserConfigurationException, InterruptedException, SAXException {
        System.out.println("===============================");
        System.out.println(tsoIspfHelper.getServiceType() + " command: ");
        System.out.println(command);
        tsoIspfHelper.runCommand(command);
        System.out.println("===============================");
        System.out.println("Command output: ");
        if (tsoIspfHelper.getServiceType().equals(SERVICE_TYPE_ISPF) && tsoIspfHelper.getReturnCode() > 0) {
            System.out.println("ISPF Gateway call failed with return code: " + tsoIspfHelper.getReturnCode());
            System.out.println(tsoIspfHelper.getReasonCode());
        }
        System.out.println(tsoIspfHelper.getOutputText());
        if (isShowLogSet) {
            System.out.println("===============================");
            System.out.println("ISPF Gateway operations log");
            System.out.println(tsoIspfHelper.getOperationsLog());
        }
        System.out.println("===============================");
        System.out.println();
    }

    private void printSkippedCommands(BufferedReader reader) throws IOException {
        String commandLine = reader.readLine();
        if (commandLine != null) {
            System.out.println("Following commands are not executed because Stop On Fail is set to true.");
            System.out.println(commandLine);
            while ((commandLine = reader.readLine()) != null) {
                System.out.println(commandLine);
            }
        }
    }
}

