/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.xml.utils.parsers;

import com.ibm.urbancode.zos.deploy.xml.utils.ContainerResource;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.XmlHelper;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class RollbackManifestParser {
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String CONTAINER_TYPE_PDS_VALUE = "PDS";
    private static final String CONTAINER_TYPE_SEQ_VALUE = "sequential";
    private static final String CREATED_TAG = "created";
    private static final String UPDATED_TAG = "updated";
    private static final String DELETED_TAG = "deleted";
    private static final String CONTAINER_TAG = "container";
    private static final String RESOURCE_TAG = "resource";
    private static final String MISSING_ATTRIBUTE = "missing";
    private final InputStream rollbackInputStream;
    private final String encoding;
    private final HashMap<String, Set<ManifestContainer>> parsedRollbackDataMap = new HashMap();
    private final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private Map<String, ManifestContainer> datasetMap = new LinkedHashMap<String, ManifestContainer>();
    private Set<ManifestContainer> containers = new LinkedHashSet<ManifestContainer>();
    private ManifestContainer container = null;
    private String actionName = null;
    private boolean isInsideActionTag = false;
    private boolean isInsidePDSContainer = false;

    protected RollbackManifestParser(InputStream rollbackInputStream, String encoding) {
        this.rollbackInputStream = rollbackInputStream;
        this.encoding = encoding;
    }

    public RollbackManifestParser(InputStream rollbackInputStream) {
        this(rollbackInputStream, "CP037");
    }

    public HashMap<String, Set<ManifestContainer>> parse() throws XMLStreamException {
        try (XMLEventReader eventReader4RollbackXml = null;){
            eventReader4RollbackXml = this.inputFactory.createXMLEventReader(this.rollbackInputStream, this.encoding);
            while (eventReader4RollbackXml.hasNext()) {
                XMLEvent event = eventReader4RollbackXml.nextEvent();
                if (event.isStartElement()) {
                    this.processStartElement(event);
                    continue;
                }
                if (!event.isEndElement()) continue;
                this.processEndElement(event);
            }
        }
        return this.parsedRollbackDataMap;
    }

    private void processStartElement(XMLEvent shipListReaderEvent) {
        StartElement startElement = shipListReaderEvent.asStartElement();
        String nodeName = startElement.getName().getLocalPart().trim();
        if (this.isActionTag(nodeName)) {
            this.isInsideActionTag = true;
            this.actionName = nodeName;
        } else if (this.isInsideActionTag) {
            if (CONTAINER_TAG.equalsIgnoreCase(nodeName)) {
                this.processContainerTag(startElement);
            } else if (RESOURCE_TAG.equalsIgnoreCase(nodeName) && this.isInsidePDSContainer) {
                this.processResourceTag(startElement);
            }
        }
    }

    private void processContainerTag(StartElement startElement) {
        String containerType = XmlHelper.getAttributeValue(startElement, TYPE_ATTRIBUTE);
        String containerName = XmlHelper.getAttributeValue(startElement, NAME_ATTRIBUTE);
        if (containerType.equalsIgnoreCase(CONTAINER_TYPE_PDS_VALUE)) {
            this.isInsidePDSContainer = true;
            this.container = this.datasetMap.getOrDefault(containerName, new ManifestContainer(containerName));
            this.container.setType(containerType);
        } else {
            this.isInsidePDSContainer = false;
            if (containerType.equalsIgnoreCase(CONTAINER_TYPE_SEQ_VALUE)) {
                this.container = new ManifestContainer(containerName);
                this.container.setType(containerType);
                if (this.isInsideDeletedActionTag() && this.hasMissingAttribute(startElement)) {
                    this.container.setMissing();
                }
                this.containers.add(this.container);
            }
        }
    }

    private void processResourceTag(StartElement startElement) {
        String resourceName = XmlHelper.getAttributeValue(startElement, NAME_ATTRIBUTE);
        ContainerResource resource = new ContainerResource(resourceName);
        if (this.isInsideDeletedActionTag() && this.hasMissingAttribute(startElement)) {
            resource.setMissing();
        }
        this.container.addContainerResource(resource);
    }

    private void processEndElement(XMLEvent xmlEvent) {
        EndElement endElement = xmlEvent.asEndElement();
        String endNodeName = endElement.getName().getLocalPart().trim();
        if (this.isActionTag(endNodeName)) {
            this.parsedRollbackDataMap.put(this.actionName, this.containers);
            this.actionName = null;
            this.isInsideActionTag = false;
            this.isInsidePDSContainer = false;
            this.datasetMap = new LinkedHashMap<String, ManifestContainer>();
            this.containers = new HashSet<ManifestContainer>();
            this.container = null;
        } else if (CONTAINER_TAG.equalsIgnoreCase(endNodeName)) {
            if (this.isInsidePDSContainer) {
                this.containers.add(this.container);
                this.datasetMap.put(this.container.getName(), this.container);
                this.isInsidePDSContainer = false;
            }
            this.container = null;
        }
    }

    private boolean isActionTag(String nodeName) {
        return CREATED_TAG.equalsIgnoreCase(nodeName) || UPDATED_TAG.equalsIgnoreCase(nodeName) || DELETED_TAG.equalsIgnoreCase(nodeName);
    }

    private boolean isInsideDeletedActionTag() {
        return DELETED_TAG.equalsIgnoreCase(this.actionName);
    }

    private boolean hasMissingAttribute(StartElement startElement) {
        return Boolean.parseBoolean(XmlHelper.getAttributeValue(startElement, MISSING_ATTRIBUTE));
    }
}

