/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.build.ant.jni;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import com.ibm.teamz.build.ant.jni.Executable;
import com.ibm.teamz.build.ant.zos.exceptions.UndefinedRecordFormatException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class ISPFStatistics {
    private static final String EIGHT_SPACES = "        ";
    private static final String IBM_1047 = "IBM-1047";
    private static final String SHR_REUSE = "shr reuse";
    private static final int INITIAL_VERSION = 1;
    private static final int MAXIMUM_MOD = 99;
    private static final int ENTRY_LENGTH = 30;
    private static final int EIGHT = 8;
    private static final byte CENTURY_INDICATOR_1900 = 0;
    private static final byte CENTURY_INDICATOR_2000 = 1;
    private static final String TWO_SLASHES_AND_SINGLE_QUOTE = "//'";
    private static final String SINGLE_QUOTE = "'";
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy");
    private String dataSet;
    private String member;
    private int version = 1;
    private int mod;
    private byte flags;
    private Date creationDate = new Date(0L);
    private Date modificationDate = (Date)this.creationDate.clone();
    private int currentLines;
    private int initialLines;
    private int modifiedLines;
    private String userid = ZUtil.getCurrentUser();

    private native int updatePdsDirectory(byte[] var1, byte[] var2, byte[] var3);

    private native int getPdsDirectory(byte[] var1, byte[] var2);

    public String toString() {
        return "ISPF Statistics:" + this.member + " " + this.version + "." + this.mod + " Created: " + DATE_FORMAT.format(this.creationDate) + " Last Modified: " + DATE_FORMAT.format(this.modificationDate) + " Current Lines: " + this.currentLines + " Initial Lines: " + this.initialLines + " Modified Lines: " + this.modifiedLines + " Userid: " + this.userid;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getMod() {
        return this.mod;
    }

    public void setMod(int mod) {
        this.mod = mod;
    }

    public byte getFlags() {
        return this.flags;
    }

    public int getVersion() {
        return this.version;
    }

    public void setFlags(byte flags) {
        this.flags = flags;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
        if (this.getCreationDate().equals(new Date(0L))) {
            this.setCreationDate(modificationDate);
        }
    }

    public int getCurrentLines() {
        return this.currentLines;
    }

    public void setCurrentLines(int currentLines) {
        this.currentLines = currentLines;
    }

    public int getInitialLines() {
        return this.initialLines;
    }

    public void setInitialLines(int initialLines) {
        this.initialLines = initialLines;
    }

    public int getModifiedLines() {
        return this.modifiedLines;
    }

    public void setModifiedLines(int modifiedLines) {
        this.modifiedLines = modifiedLines;
    }

    public String getUserId() {
        return this.userid;
    }

    public void setUserId(String userId) {
        this.userid = userId;
    }

    public String getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(String dataSet) {
        this.dataSet = dataSet;
    }

    public String getMember() {
        return this.member;
    }

    public void setMember(String member) {
        this.member = member;
    }

    public ISPFStatistics() {
    }

    public ISPFStatistics(String dataSet, String member) throws Exception {
        this(dataSet, member, false);
    }

    public ISPFStatistics(String dataSet, String member, boolean ssi) throws Exception {
        this();
        this.dataSet = dataSet;
        if (member != null) {
            this.member = member.toUpperCase(Locale.US);
        }
        this.init(ssi);
    }

    private static byte getPackedDecimal(int i) {
        return (byte)((i / 10 << 4 | i % 10) & 0xFF);
    }

    private static int parsePackedDecimal(byte b) {
        return ((b & 0xF0) >> 4) * 10 + (b & 0xF);
    }

    private void readUserData(byte[] entry) {
        this.version = entry[0] & 0xFF;
        this.mod = entry[1] & 0xFF;
        this.flags = entry[2];
        Calendar cal = Calendar.getInstance();
        cal.clear();
        boolean century2000 = entry[4] == 1;
        int year = (century2000 ? 2000 : 1900) + ISPFStatistics.parsePackedDecimal(entry[5]);
        int julianDate = ISPFStatistics.parsePackedDecimal(entry[6]) * 10 + ISPFStatistics.parsePackedDecimal((byte)((entry[7] & 0xF0) >> 4));
        cal.set(1, year);
        cal.set(6, julianDate);
        this.setCreationDate(cal.getTime());
        cal.clear();
        century2000 = entry[8] == 1;
        year = (century2000 ? 2000 : 1900) + ISPFStatistics.parsePackedDecimal(entry[9]);
        julianDate = ISPFStatistics.parsePackedDecimal(entry[10]) * 10 + ISPFStatistics.parsePackedDecimal((byte)((entry[11] & 0xF0) >> 4));
        int hour = ISPFStatistics.parsePackedDecimal(entry[12]);
        int minute = ISPFStatistics.parsePackedDecimal(entry[13]);
        int second = ISPFStatistics.parsePackedDecimal(entry[3]);
        cal.set(1, year);
        cal.set(6, julianDate);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        this.setModificationDate(cal.getTime());
        this.currentLines = ISPFStatistics.getIntFromTwoBytes(entry[14], entry[15]);
        this.initialLines = ISPFStatistics.getIntFromTwoBytes(entry[16], entry[17]);
        this.modifiedLines = ISPFStatistics.getIntFromTwoBytes(entry[18], entry[19]);
        try {
            this.userid = new String(entry, 20, 7, IBM_1047);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getUserData() {
        byte[] entry = new byte[30];
        Calendar lastModified = Calendar.getInstance();
        lastModified.setTime(this.modificationDate);
        Calendar creation = Calendar.getInstance();
        creation.setTime(this.creationDate);
        entry[0] = (byte)this.version;
        entry[1] = (byte)this.mod;
        entry[2] = this.flags;
        int second = lastModified.get(13);
        entry[3] = ISPFStatistics.getPackedDecimal(second);
        int year = creation.get(1);
        entry[4] = year >= 2000 ? (byte)1 : 0;
        entry[5] = ISPFStatistics.getPackedDecimal(year % 100);
        int julianDate = creation.get(6);
        entry[6] = ISPFStatistics.getPackedDecimal(julianDate / 10);
        entry[7] = (byte)(julianDate % 10 << 4 | 0xF);
        year = lastModified.get(1);
        entry[8] = year >= 2000 ? (byte)1 : 0;
        entry[9] = ISPFStatistics.getPackedDecimal(year % 100);
        julianDate = lastModified.get(6);
        entry[10] = ISPFStatistics.getPackedDecimal(julianDate / 10);
        entry[11] = (byte)(julianDate % 10 << 4 | 0xF);
        int hour = lastModified.get(11);
        entry[12] = ISPFStatistics.getPackedDecimal(hour);
        int minute = lastModified.get(12);
        entry[13] = ISPFStatistics.getPackedDecimal(minute);
        entry[14] = ISPFStatistics.getHiByteFromInt(this.currentLines);
        entry[15] = ISPFStatistics.getLoByteFromInt(this.currentLines);
        entry[16] = ISPFStatistics.getHiByteFromInt(this.initialLines);
        entry[17] = ISPFStatistics.getLoByteFromInt(this.initialLines);
        entry[18] = ISPFStatistics.getHiByteFromInt(this.modifiedLines);
        entry[19] = ISPFStatistics.getLoByteFromInt(this.modifiedLines);
        byte[] userIdBytes = null;
        try {
            userIdBytes = this.userid.getBytes(IBM_1047);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int index = 20;
        if (userIdBytes != null) {
            for (int i = 0; i < userIdBytes.length; ++i) {
                entry[index++] = userIdBytes[i];
            }
        }
        while (index <= 29) {
            entry[index++] = 64;
        }
        return entry;
    }

    public static int getIntFromTwoBytes(byte hi, byte lo) {
        return (hi & 0xFF) << 8 | lo & 0xFF;
    }

    public static byte getHiByteFromInt(int i) {
        return (byte)(i >> 8 & 0xFF);
    }

    public static byte getLoByteFromInt(int i) {
        return (byte)(i & 0xFF);
    }

    public static void dumpBytes(byte[] b) {
        if (b == null) {
            return;
        }
        for (int i = 0; i < b.length; ++i) {
            System.out.print(String.format("%02x ", b[i] & 0xFF));
            if (i % 16 != 15) continue;
            System.out.println();
        }
    }

    public Object clone() {
        ISPFStatistics o = new ISPFStatistics();
        o.setDataSet(this.dataSet);
        o.setMember(this.member);
        o.setCreationDate(this.creationDate);
        o.setFlags(this.flags);
        o.setInitialLines(this.initialLines);
        o.setModificationDate(this.modificationDate);
        o.setCurrentLines(this.initialLines);
        o.setMod(this.mod);
        o.setModifiedLines(this.modifiedLines);
        o.setUserId(this.userid);
        o.setVersion(this.version);
        return o;
    }

    private static String getPaddedMemberName(String member) {
        String paddedMemberName = member;
        if (paddedMemberName != null) {
            int len = paddedMemberName.length();
            if (len > 8) {
                paddedMemberName = paddedMemberName.substring(0, 8);
            } else if (len < 8) {
                paddedMemberName = paddedMemberName + EIGHT_SPACES.substring(0, 8 - len);
            }
        }
        return paddedMemberName;
    }

    private static byte[] getBldlBuffer(ISPFStatistics stats) {
        int len = 78;
        byte[] b = new byte[len];
        b[0] = 0;
        b[1] = 1;
        b[2] = 0;
        b[3] = 74;
        String member = stats.getMember();
        if (member != null) {
            byte[] b_name = null;
            try {
                b_name = ISPFStatistics.getPaddedMemberName(member).getBytes(IBM_1047);
                System.arraycopy(b_name, 0, b, 4, b_name.length);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return b;
    }

    private static byte[] getStowBuffer(ISPFStatistics stats) {
        byte[] b = null;
        if (stats == null) {
            return null;
        }
        String member = stats.getMember();
        if (member != null) {
            int i;
            byte[] b_name = null;
            try {
                b_name = ISPFStatistics.getPaddedMemberName(member).getBytes(IBM_1047);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            byte[] user_data = stats.getUserData();
            int len = 12;
            if (user_data != null) {
                len += user_data.length;
            }
            b = new byte[74];
            for (i = 0; i < 8; ++i) {
                b[i] = 64;
            }
            for (i = 8; i < len; ++i) {
                b[i] = 0;
            }
            System.arraycopy(b_name, 0, b, 0, b_name.length);
            b[11] = 0;
            if (user_data != null) {
                b[11] = (byte)(user_data.length / 2);
                System.arraycopy(user_data, 0, b, 12, user_data.length);
            }
        }
        return b;
    }

    private void init(boolean ssi) throws Exception {
        String dsnMember = TWO_SLASHES_AND_SINGLE_QUOTE + this.dataSet + "(" + this.member + ")" + SINGLE_QUOTE;
        try (ZFile f = null;){
            f = new ZFile(dsnMember, "r");
            boolean unformatted = f.getRecfm().startsWith("U");
            if (unformatted && !ssi || !unformatted && ssi) {
                throw new UndefinedRecordFormatException();
            }
        }
        String dd = ZFile.allocDummyDDName();
        ISPFStatistics.alloc(dd, this.getDataSet(), SHR_REUSE);
        byte[] bldlBuffer = ISPFStatistics.getBldlBuffer(this);
        int rc = this.getPdsDirectory(dd.getBytes(IBM_1047), bldlBuffer);
        ISPFStatistics.free(dd);
        if (rc == 0) {
            int userDataLen = (bldlBuffer[17] & 0x1F) * 2;
            if (!ssi && userDataLen == 30) {
                byte[] userData = new byte[30];
                System.arraycopy(bldlBuffer, 18, userData, 0, 30);
                this.readUserData(userData);
            } else if (ssi && userDataLen > 26) {
                byte[] userData = new byte[26];
                System.arraycopy(bldlBuffer, 18, userData, 0, 26);
                long timestamp = (((long)userData[22] & 0xFFL) << 24 | ((long)userData[23] & 0xFFL) << 16 | ((long)userData[24] & 0xFFL) << 8 | (long)userData[25] & 0xFFL) * 1000L;
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.setTimeInMillis(timestamp);
                this.setModificationDate(cal.getTime());
            }
        } else {
            throw new Exception("BLDL faild for data set " + this.getDataSet() + "(" + this.getMember() + ")");
        }
    }

    private static void alloc(String dd, String dsn, String attr) {
        String cmd = "alloc dd(" + dd + ")";
        if (dsn != null) {
            cmd = cmd + " dsn('" + dsn + "')";
        }
        cmd = cmd + " " + attr;
        ZFile.bpxwdyn((String)cmd);
    }

    private static void free(String dd) {
        String cmd = "free dd(" + dd + ")";
        ZFile.bpxwdyn((String)cmd);
    }

    public int save() throws UnsupportedEncodingException {
        int mod = this.getMod();
        if (mod < 99) {
            this.setMod(++mod);
        }
        String dd = ZFile.allocDummyDDName();
        ISPFStatistics.alloc(dd, this.getDataSet(), SHR_REUSE);
        int rc = this.updatePdsDirectory(this.member.getBytes(IBM_1047), dd.getBytes(IBM_1047), ISPFStatistics.getStowBuffer(this));
        ISPFStatistics.free(dd);
        return rc;
    }

    static {
        Executable.loadNativeLibrary();
    }
}

