/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayExecutor;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLInput;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLResponse;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TsoIspfHelper {
    private static final String SERVICE_TYPE_ISPF = "ISPF";
    private static final String SESSION_REUSE = "REUSE";
    private static final String SESSION_NONE = "NONE";
    private static final String SERVICE_TYPE_TSO = "TSO";
    private static final String ISPF_RETURN_CODE_TEXT = "The initially invoked CLIST ended with a return code = ";
    private static final String PATH = "PATH";
    private final String session;
    private final String ispfGatewayPath;
    private final String serviceType;
    private final String ispProf;
    private String outputText;
    private int returnCode;
    private String reasonCode;
    private String operationsLog;

    public TsoIspfHelper(String ispfGatewayPath, boolean reuseSession, String serviceType, String ispProf) {
        this.ispfGatewayPath = ispfGatewayPath;
        this.session = reuseSession ? SESSION_REUSE : SESSION_NONE;
        this.serviceType = serviceType;
        this.ispProf = ispProf;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public String getOutputText() {
        return this.outputText;
    }

    public String getOperationsLog() {
        return this.operationsLog;
    }

    public void runCommand(String command) throws IOException, ParserConfigurationException, InterruptedException, SAXException {
        this.initializeOutputFields();
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        environmentVariables.put(PATH, System.getenv(PATH) + File.pathSeparator + this.ispfGatewayPath);
        IspfGatewayExecutor ispfGatewayExecutor = new IspfGatewayExecutor(this.ispfGatewayPath, this.getIspfGatewayInput(command));
        ispfGatewayExecutor.setEnvironmentVars(environmentVariables);
        this.executeCommandUsingIspfGateway(ispfGatewayExecutor);
    }

    private void initializeOutputFields() {
        this.outputText = "";
        this.operationsLog = "";
        this.returnCode = 0;
        this.reasonCode = "";
    }

    private IspfGatewayXMLInput getIspfGatewayInput(String command) {
        IspfGatewayXMLInput ispfGatewayXMLInput = new IspfGatewayXMLInput(this.serviceType, command);
        ispfGatewayXMLInput.setSession(this.session);
        if (this.serviceType.equals(SERVICE_TYPE_ISPF)) {
            ispfGatewayXMLInput.setIspProf(this.ispProf);
        }
        return ispfGatewayXMLInput;
    }

    private void executeCommandUsingIspfGateway(IspfGatewayExecutor ispfGatewayExecutor) throws IOException, ParserConfigurationException, InterruptedException, SAXException {
        IspfGatewayXMLResponse ispfGatewayXMLResponse = ispfGatewayExecutor.execute();
        this.operationsLog = ispfGatewayXMLResponse.getOperationsLog();
        if (this.serviceType.equals(SERVICE_TYPE_TSO)) {
            this.processTsoCommandOutput(ispfGatewayXMLResponse);
        } else if (this.serviceType.equals(SERVICE_TYPE_ISPF)) {
            this.processIspfCommandOutput(ispfGatewayXMLResponse);
        }
    }

    private void processIspfCommandOutput(IspfGatewayXMLResponse ispfGatewayXMLResponse) {
        this.outputText = ispfGatewayXMLResponse.getOutputText();
        this.returnCode = Integer.parseInt(ispfGatewayXMLResponse.getReturnCode());
        if (this.returnCode > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String reasonCode : ispfGatewayXMLResponse.getReasonCodeList()) {
                stringBuilder.append(reasonCode).append(System.lineSeparator());
            }
            this.reasonCode = stringBuilder.toString();
        } else {
            int errorTextIndex = this.outputText.indexOf(ISPF_RETURN_CODE_TEXT);
            if (errorTextIndex > 0) {
                int returnCodeTextIndex = errorTextIndex + ISPF_RETURN_CODE_TEXT.length();
                this.returnCode = Integer.parseInt(this.outputText.substring(returnCodeTextIndex).trim());
            }
        }
    }

    private void processTsoCommandOutput(IspfGatewayXMLResponse ispfGatewayXMLResponse) {
        this.outputText = ispfGatewayXMLResponse.getOutputText();
    }
}

