/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.xml.utils;

import com.ibm.urbancode.zos.deploy.xml.utils.ContainerResource;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.RollbackManifest;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.ContainerMapperParser;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.PackageManifestParser;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.RollbackManifestParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class DeploymentResultHelper {
    private static final String PACKAGE_MANIFEST_XML = "packageManifest.xml";
    private static final String DEPLOY_DIRECTORY = "deploy";
    private static final String CONTAINER_MAPPER_XML = "containerMapper.xml";
    private static final String ROLLBACK_MANIFEST_XML = "rollbackManifest.xml";
    private static final String DIRECTORY = "directory";

    public static Set<ManifestContainer> getDeployedDataSets(String deployBasePath, String resourceId, String componentName, String versionName) throws IOException, XMLStreamException {
        Set<ManifestContainer> deployedDatasets;
        try (InputStream packageManifestInputStream = Files.newInputStream(Paths.get(DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, PACKAGE_MANIFEST_XML, true), new String[0]), new OpenOption[0]);){
            deployedDatasets = new PackageManifestParser(packageManifestInputStream).parse();
        }
        Map<String, String> rulerMapper = DeploymentResultHelper.getDeployContainerMapper(deployBasePath, resourceId, componentName, versionName);
        DeploymentResultHelper.updateTargetDatasetUsingMapper(deployedDatasets, rulerMapper);
        return deployedDatasets;
    }

    private static void updateTargetDatasetUsingMapper(Set<ManifestContainer> deployedDatasets, Map<String, String> rulerMapper) {
        for (ManifestContainer currentDeployedManifestContainer : deployedDatasets) {
            if (!DeploymentResultHelper.isNotDirectoryType(currentDeployedManifestContainer)) continue;
            String targetDsName = rulerMapper.get(currentDeployedManifestContainer.getName());
            currentDeployedManifestContainer.setName(targetDsName);
            if (currentDeployedManifestContainer.getContainerResources() == null) continue;
            for (ContainerResource containerResource : currentDeployedManifestContainer.getContainerResources()) {
                containerResource.setContainerName(targetDsName);
            }
        }
    }

    private static boolean isNotDirectoryType(ManifestContainer currentDeployedManifestContainer) {
        return !DIRECTORY.equals(currentDeployedManifestContainer.getType());
    }

    public static RollbackManifest getRollbackStructure(String deployBasePath, String resourceId, String componentName, String versionName) throws IOException, XMLStreamException {
        RollbackManifest rollbackManifest;
        try (InputStream rollbackInputStream = Files.newInputStream(Paths.get(DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, ROLLBACK_MANIFEST_XML, true), new String[0]), new OpenOption[0]);){
            rollbackManifest = new RollbackManifestParser(rollbackInputStream).parse();
        }
        return rollbackManifest;
    }

    public static Set<ManifestContainer> getNotDeployedDataSets(String manifestFilePath) throws IOException, XMLStreamException {
        Set<ManifestContainer> notDeployedDatasets;
        try (InputStream packageManifestInputStream = Files.newInputStream(Paths.get(manifestFilePath, new String[0]), new OpenOption[0]);){
            notDeployedDatasets = new PackageManifestParser(packageManifestInputStream).parse();
        }
        return notDeployedDatasets;
    }

    public static boolean checkVersionDeployed(String deployBasePath, String resourceId, String componentName, String versionName) {
        String packageManifestFilePath = DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, PACKAGE_MANIFEST_XML, false);
        File packageManifestFile = new File(packageManifestFilePath);
        return packageManifestFile.exists();
    }

    public static Set<ManifestContainer> getOnlyDeployedContainers(Set<ManifestContainer> containers) {
        HashSet<ManifestContainer> onlyDeployedContainers = new HashSet<ManifestContainer>();
        for (ManifestContainer container : containers) {
            if (container.isDeleted()) continue;
            onlyDeployedContainers.add(container);
        }
        return onlyDeployedContainers;
    }

    public static Set<ManifestContainer> getOnlyDeletedContainers(Set<ManifestContainer> containers) {
        HashSet<ManifestContainer> onlyDeletedContainers = new HashSet<ManifestContainer>();
        for (ManifestContainer container : containers) {
            if (!container.isDeleted()) continue;
            onlyDeletedContainers.add(container);
        }
        return onlyDeletedContainers;
    }

    private static Map<String, String> getDeployContainerMapper(String deployBasePath, String resourceId, String componentName, String versionName) throws IOException, XMLStreamException {
        Map<String, String> deployContainerMapper = new HashMap<String, String>();
        String containerMapperFilePath = DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, CONTAINER_MAPPER_XML, false);
        File file = new File(containerMapperFilePath);
        if (!file.exists() || !file.isFile()) {
            return deployContainerMapper;
        }
        try (InputStream containerMapperInputStream = Files.newInputStream(Paths.get(DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, CONTAINER_MAPPER_XML, false), new String[0]), new OpenOption[0]);){
            deployContainerMapper = new ContainerMapperParser(containerMapperInputStream).parse();
        }
        return deployContainerMapper;
    }

    private static String getDeployMetaFilePath(String deployBasePath, String resourceId, String componentName, String versionName, String fileName, boolean checkExist) {
        File file;
        String metaFilePath = deployBasePath + File.separator + DEPLOY_DIRECTORY + File.separator + resourceId + File.separator + componentName + File.separator + versionName + File.separator + fileName;
        if (!(!checkExist || (file = new File(metaFilePath)).exists() && file.isFile())) {
            throw new IllegalArgumentException(metaFilePath + " not found, please make sure the version has been successfully deployed");
        }
        return metaFilePath;
    }
}

