/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.common.util.DeploymentFilesHelper;
import com.ibm.urbancode.zos.common.util.GenericHelper;
import com.ibm.urbancode.zos.common.util.JDeploymentHelper;
import com.ibm.urbancode.zos.common.util.UdClientHelper;
import com.ibm.urbancode.zos.deploy.xml.utils.ContainerResource;
import com.ibm.urbancode.zos.deploy.xml.utils.DeploymentResultHelper;
import com.ibm.urbancode.zos.deploy.xml.utils.Inputs;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import com.urbancode.air.plugin.inputs.MissingInputException;
import com.urbancode.commons.util.ssl.XTrustProvider;
import com.urbancode.ud.client.VersionClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;

public class GenerateVersionArtifactInfo {
    private final Properties inputProperties;
    private final Properties outputProperties;

    public GenerateVersionArtifactInfo(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws IOException, XMLStreamException, URISyntaxException {
        Set allContainers;
        String loopType = JDeploymentHelper.getStringInput(this.inputProperties.getProperty("loopType"));
        String deployTypeName = JDeploymentHelper.getStringInput(this.inputProperties.getProperty("deployTypeName"));
        String srcDatasetName = JDeploymentHelper.getStringInput(this.inputProperties.getProperty("srcDatasetName"));
        String targetDatasetName = JDeploymentHelper.getStringInput(this.inputProperties.getProperty("datasetName"));
        String memberName = JDeploymentHelper.getStringInput(this.inputProperties.getProperty("memberName"));
        String custProperties = JDeploymentHelper.getStringInput(this.inputProperties.getProperty("custProperties"));
        String template = this.inputProperties.getProperty("templateText");
        String orderBy = JDeploymentHelper.getStringInput(this.inputProperties.getProperty("orderBy"));
        boolean failOnEmpty = JDeploymentHelper.getBooleanInput(this.inputProperties.getProperty("failOnEmpty"));
        boolean ignoreUnresolved = JDeploymentHelper.getBooleanInput(this.inputProperties.getProperty("ignoreUnresolved"));
        String deployBasePath = JDeploymentHelper.getStringInput(this.inputProperties.getProperty("deployBasePath"));
        String componentName = JDeploymentHelper.getStringInput(this.inputProperties.getProperty("componentName"));
        String versionName = JDeploymentHelper.getStringInput(this.inputProperties.getProperty("versionName"));
        String resourceId = JDeploymentHelper.getStringInput(this.inputProperties.getProperty("resourceId"));
        LinkedHashSet containerLevels = new LinkedHashSet();
        Collections.addAll(containerLevels, "PDS", "DeletedPDS", "Sequential", "DeletedSequential", "GenericArtifactGroup", "Directory");
        LinkedHashSet resourceLevels = new LinkedHashSet();
        Collections.addAll(resourceLevels, "Member", "DeletedMember", "GenericArtifact", "File", "DeletedFile");
        if (GenericHelper.isNullOrEmpty(componentName)) {
            throw new MissingInputException("Component Name must be set.");
        }
        if (GenericHelper.isNullOrEmpty(deployBasePath)) {
            throw new MissingInputException("Deploy Base Path must be set.");
        }
        if (GenericHelper.isNullOrEmpty(versionName)) {
            throw new MissingInputException("Version Name must be set.");
        }
        if (GenericHelper.isNullOrEmpty(template = StringUtils.replace((String)template, (String)"\\n", (String)"\n"))) {
            throw new MissingInputException("Template must be set.");
        }
        JDeploymentHelper.inputNotEmptyCheck(resourceId, "Resource Id is empty.");
        if (GenericHelper.isNullOrEmpty(orderBy)) {
            orderBy = "ASC";
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new StringReader(custProperties));
        String line = reader.readLine();
        while (line != null) {
            if (!GenericHelper.isNullOrEmpty(line) && line.indexOf(61) > 0) {
                int index = line.indexOf(61);
                String propName = line.substring(0, index).trim();
                String propValue = index < line.length() - 1 ? line.substring(index + 1) : "";
                properties.put(propName, propValue);
            } else if (!GenericHelper.isNullOrEmpty(line)) {
                properties.put(line, "");
            }
            line = reader.readLine();
        }
        System.out.println("Filter: [container:" + srcDatasetName + " target dataset:" + targetDatasetName + " resource:" + memberName + " deployType:" + deployTypeName + "] " + properties);
        if (DeploymentResultHelper.checkVersionDeployed((String)deployBasePath, (String)resourceId, (String)componentName, (String)versionName)) {
            allContainers = DeploymentResultHelper.getDeployedDataSets((String)deployBasePath, (String)resourceId, (String)componentName, (String)versionName);
        } else {
            VersionClient versionClient = UdClientHelper.getVersionClient();
            XTrustProvider.install();
            String versionWorkingDir = DeploymentFilesHelper.getVersionDirPathInWorkingDir(versionName, resourceId);
            String versionManifestPath = DeploymentFilesHelper.getFilePathInWorkingDir(versionName, resourceId, "packageManifest.xml");
            PrintStream oriOut = System.out;
            System.setOut(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }));
            try {
                versionClient.downloadFiles(componentName, versionName, versionWorkingDir, "packageManifest.xml");
            }
            catch (Exception e) {
                System.setOut(oriOut);
                System.out.println("Failed to locate metadata for version.");
                System.out.println("Generate artifact information works for deployed versions or versions created with server version 6.1.1.6 and later.");
                System.exit(1);
            }
            finally {
                System.setOut(oriOut);
            }
            allContainers = DeploymentResultHelper.getNotDeployedDataSets((String)versionManifestPath);
            if (!targetDatasetName.isEmpty()) {
                System.out.println("Warning: Target Data Set Name Filter ignored because version " + versionName + " is not deployed");
                targetDatasetName = "";
            }
        }
        Set containers = loopType.toLowerCase().contains("deleted") ? DeploymentResultHelper.getOnlyDeletedContainers((Set)allContainers) : DeploymentResultHelper.getOnlyDeployedContainers((Set)allContainers);
        TreeSet treeSet = new TreeSet(containers);
        if (orderBy.equals("ASC")) {
            containers = treeSet;
        } else if (orderBy.equals("DESC")) {
            containers = treeSet.descendingSet();
        }
        System.out.println();
        StringBuilder strDataBuilder = new StringBuilder();
        int count = 0;
        for (ManifestContainer currentContainer : containers) {
            if (containerLevels.contains(loopType)) {
                Map itemCustomerProperties;
                String itemDeployType;
                String itemMemberName;
                String itemDsName;
                String itemSrcDsName;
                if (loopType.equals("PDS") && !currentContainer.getType().equals("PDS") || loopType.equals("DeletedPDS") && !currentContainer.getType().equals("PDS") || loopType.equals("Sequential") && !currentContainer.getType().equals("sequential") || loopType.equals("DeletedSequential") && !currentContainer.getType().equals("sequential") || loopType.equals("GenericArtifactGroup") && !currentContainer.getType().equalsIgnoreCase("GENERIC") || loopType.equals("Directory") && !currentContainer.getType().equals("directory") || !this.filter(itemSrcDsName = currentContainer.getSrcContainerName(), itemDsName = currentContainer.getName(), itemMemberName = "", itemDeployType = currentContainer.getDeployType(), itemCustomerProperties = currentContainer.getCustomerProperties(), deployTypeName, properties, srcDatasetName, targetDatasetName, memberName)) continue;
                HashMap<String, String> vars = new HashMap<String, String>(itemCustomerProperties);
                vars.put("sourceDataset", itemSrcDsName);
                vars.put("dataset", itemDsName);
                vars.put("member", itemMemberName);
                vars.put("deployType", itemDeployType);
                if (loopType.equals("GenericArtifactGroup")) {
                    vars.put("artifactGroup", itemSrcDsName);
                    vars.put("artifact", itemMemberName);
                } else if (loopType.equals("Directory")) {
                    vars.put("directory", itemSrcDsName);
                    vars.put("file", itemMemberName);
                }
                String envline = this.envCommand(template, vars, itemDsName, ignoreUnresolved);
                strDataBuilder.append(envline);
                ++count;
                continue;
            }
            if (!resourceLevels.contains(loopType) || loopType.equals("Member") && !currentContainer.getType().equals("PDS") || loopType.equals("DeletedMember") && !currentContainer.getType().equals("PDS") || loopType.equals("GenericArtifact") && !currentContainer.getType().equalsIgnoreCase("GENERIC") || loopType.equals("File") && !currentContainer.getType().equals("directory") || loopType.equals("DeletedFile") && !currentContainer.getType().equals("directory")) continue;
            Map pdsCustomerProperties = currentContainer.getCustomerProperties();
            NavigableSet deployedMembersInCurrentDataSet = currentContainer.getContainerResources();
            if (orderBy.equals("ASC")) {
                deployedMembersInCurrentDataSet = new TreeSet(deployedMembersInCurrentDataSet);
            } else if (orderBy.equals("DESC")) {
                deployedMembersInCurrentDataSet = new TreeSet(deployedMembersInCurrentDataSet).descendingSet();
            }
            if (deployedMembersInCurrentDataSet == null) continue;
            for (ContainerResource member : deployedMembersInCurrentDataSet) {
                String itemSrcDsName = member.getSrcContainerName();
                String itemDsName = member.getContainerName();
                String itemMemberName = member.getName();
                String itemDeployType = member.getDeployType();
                Map itemCustomerProperties = member.getCustomerProperties();
                Inputs inputs = member.getInputs();
                itemCustomerProperties.putAll(pdsCustomerProperties);
                if (!this.filter(itemSrcDsName, itemDsName, itemMemberName, itemDeployType, itemCustomerProperties, deployTypeName, properties, srcDatasetName, targetDatasetName, memberName)) continue;
                HashMap<String, String> vars = new HashMap<String, String>(itemCustomerProperties);
                vars.put("sourceDataset", itemSrcDsName);
                vars.put("dataset", itemDsName);
                vars.put("member", itemMemberName);
                vars.put("deployType", itemDeployType);
                vars.put("inputsUrl", inputs.getUrl());
                if (loopType.equals("GenericArtifact")) {
                    vars.put("artifactGroup", itemSrcDsName);
                    vars.put("artifact", itemMemberName);
                } else if (loopType.equals("File") || loopType.equals("DeletedFile")) {
                    vars.put("directory", itemSrcDsName);
                    vars.put("file", itemMemberName);
                }
                String envline = this.envCommand(template, vars, itemDsName, ignoreUnresolved);
                strDataBuilder.append(envline);
                ++count;
            }
        }
        System.out.println();
        System.out.println("Output text:");
        System.out.println("========================================================================================================================");
        String text = strDataBuilder.toString();
        System.out.println(text);
        System.out.println("========================================================================================================================");
        this.outputProperties.setProperty("text", text);
        this.outputProperties.setProperty("count", Integer.toString(count));
        if (failOnEmpty && text.trim().length() == 0) {
            System.out.println("Step failed because Fail On Empty is checked and the generation result is empty.");
            System.exit(1);
        }
        return 0;
    }

    public boolean filter(String srcDsName, String dsName, String memberName, String deployType, Map<String, String> customerProperties, String filterDeployType, Map<String, String> filterProperties, String filterSrcDsName, String filterDsName, String filterMemberName) {
        String pattern;
        System.out.println("Apply filter to " + srcDsName + " - " + dsName + "(" + memberName + ") " + customerProperties);
        if (!filterDeployType.isEmpty()) {
            if (filterDeployType.startsWith("/") && filterDeployType.endsWith("/")) {
                pattern = filterDeployType.substring(1, filterDeployType.length() - 1);
                if (deployType == null || !deployType.matches(pattern)) {
                    System.out.println("  Not selected because deployType=" + filterDeployType + " does not match");
                    return false;
                }
            } else if (deployType == null || !deployType.equals(filterDeployType)) {
                System.out.println("  Not selected because deployType=" + filterDeployType + " does not match");
                return false;
            }
        }
        if (!filterDsName.isEmpty()) {
            if (filterDsName.startsWith("/") && filterDsName.endsWith("/")) {
                pattern = filterDsName.substring(1, filterDsName.length() - 1);
                if (!dsName.matches(pattern)) {
                    System.out.println("  Not selected because target data set name=" + filterDsName + " does not match");
                    return false;
                }
            } else if (!dsName.equals(filterDsName)) {
                System.out.println("  Not selected because target data set name=" + filterDsName + " does not match");
                return false;
            }
        }
        if (!filterSrcDsName.isEmpty()) {
            if (filterSrcDsName.startsWith("/") && filterSrcDsName.endsWith("/")) {
                pattern = filterSrcDsName.substring(1, filterSrcDsName.length() - 1);
                if (!srcDsName.matches(pattern)) {
                    System.out.println("  Not selected because container name=" + filterSrcDsName + " does not match");
                    return false;
                }
            } else if (!srcDsName.equals(filterSrcDsName)) {
                System.out.println("  Not selected because container name=" + filterSrcDsName + " does not match");
                return false;
            }
        }
        if (!filterMemberName.isEmpty()) {
            if (filterMemberName.startsWith("/") && filterMemberName.endsWith("/")) {
                pattern = filterMemberName.substring(1, filterMemberName.length() - 1);
                if (memberName == null || !memberName.matches(pattern)) {
                    System.out.println("  Not selected because resource name=" + filterMemberName + " does not match");
                    return false;
                }
            } else if (memberName == null || !memberName.equals(filterMemberName)) {
                System.out.println("  Not selected because resource name=" + filterMemberName + " does not match");
                return false;
            }
        }
        for (Map.Entry<String, String> entry : filterProperties.entrySet()) {
            String filterPropKey = entry.getKey();
            String filterPropValue = entry.getValue();
            boolean match = false;
            if (customerProperties.size() != 0) {
                for (Map.Entry<String, String> entryCustProp : customerProperties.entrySet()) {
                    String custKey = entryCustProp.getKey();
                    String custValue = entryCustProp.getValue();
                    if (!custKey.equals(filterPropKey)) continue;
                    if (filterPropValue.isEmpty()) {
                        match = true;
                        continue;
                    }
                    if (filterPropValue.startsWith("/") && filterPropValue.endsWith("/")) {
                        String pattern2 = filterPropValue.substring(1, filterPropValue.length() - 1);
                        if (!custValue.matches(pattern2)) continue;
                        match = true;
                        continue;
                    }
                    if (!custValue.equals(filterPropValue)) continue;
                    match = true;
                }
            }
            if (match) continue;
            System.out.println("Not selected because custom property " + filterPropKey + "=" + filterPropValue + " does not match");
            return false;
        }
        return true;
    }

    public String envCommand(String s, Map<String, String> vars, String itemDSN, boolean ignoreUnresolved) {
        for (Map.Entry<String, String> entry : vars.entrySet()) {
            s = StringUtils.replace((String)s, (String)("${" + entry.getKey() + "}"), (String)entry.getValue());
        }
        Pattern pattern = Pattern.compile("\\$\\{.+}");
        Matcher matcher = pattern.matcher(s);
        if (matcher.find() && !ignoreUnresolved) {
            throw new IllegalArgumentException("Missing property for data set " + itemDSN + ". Please make sure the property is set on the data set.");
        }
        return s;
    }
}

