/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.packaging.common.extrepo;

import com.ibm.urbancode.zos.packaging.common.Console;
import com.ibm.urbancode.zos.packaging.common.extrepo.ExternalRepoInputs;
import com.ibm.urbancode.zos.packaging.common.extrepo.ExternalRepoType;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder2;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ExternalRepoUploader {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String ZIP_EXTENSION = ".zip";
    private static final String REPOSITORY_LOWERCASE = "repository";
    private static final String NEXUS_REST_END_POINT = "/service/rest/v1/components?repository=";
    private final String versionName;
    private final File versionZip;
    private String urlToDownloadZip;
    private String postUrl;
    private int RESPONSE_CODE;
    private String responseBody;
    private final int httpProxyPort;
    private final String httpProxyHost;
    private final String username;
    private final String password;
    private final String url;
    private final String rawDirectory;
    private final String repositoryName;
    private final String repositoryType;
    private final ResponseHandler<String> responseHandler = response -> {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity;
            if (status == this.RESPONSE_CODE) {
                Console.printLogMessage("Version artifacts stored in External Repository server");
            }
            return (entity = response.getEntity()) != null ? EntityUtils.toString((HttpEntity)entity) : null;
        }
        System.out.println("HTTP response error code =" + response.getStatusLine().getStatusCode());
        throw new IOException("Bad request status code" + response.getStatusLine().getStatusCode() + response.toString().replace("\n", ""));
    };

    public ExternalRepoUploader(ExternalRepoInputs externalRepoInputs, String versionZipPath, String packageName) {
        this.httpProxyHost = externalRepoInputs.getHttpProxyHost();
        this.httpProxyPort = externalRepoInputs.getHttpProxyPort();
        this.username = externalRepoInputs.getUsername();
        this.url = externalRepoInputs.getUrl();
        this.repositoryType = externalRepoInputs.getRepositoryType();
        this.password = externalRepoInputs.getPassword();
        this.repositoryName = externalRepoInputs.getRepositoryName();
        this.rawDirectory = externalRepoInputs.getRawDirectory();
        this.versionName = packageName;
        this.versionZip = new File(versionZipPath);
    }

    public String getUrlToDownloadZip() {
        return this.urlToDownloadZip;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public void upload() throws IOException {
        if (this.repositoryType.equals(ExternalRepoType.ARTIFACTORY.getValue())) {
            this.RESPONSE_CODE = 201;
            this.urlToDownloadZip = this.url + FILE_SEPARATOR + this.repositoryName + FILE_SEPARATOR + this.versionName + ZIP_EXTENSION;
            this.postUrl = this.url + FILE_SEPARATOR + this.repositoryName;
            Console.printLogMessage("Uploading artifacts to " + this.repositoryType);
            this.uploadToArtifactory(this.versionZip);
        } else if (this.repositoryType.equals(ExternalRepoType.NEXUS.getValue())) {
            this.RESPONSE_CODE = 204;
            this.urlToDownloadZip = this.url + FILE_SEPARATOR + REPOSITORY_LOWERCASE + FILE_SEPARATOR + this.repositoryName + FILE_SEPARATOR + this.rawDirectory + FILE_SEPARATOR + this.versionName + ZIP_EXTENSION;
            this.postUrl = this.url + NEXUS_REST_END_POINT + this.repositoryName;
            Console.printLogMessage("Uploading artifacts to " + this.repositoryType);
            this.uploadToNexus(this.versionZip);
        } else {
            throw new IllegalArgumentException("Unsupported repository type " + this.repositoryType + ". Artifactory (or) Nexus are valid values");
        }
    }

    private void uploadToArtifactory(File versionZip) throws IOException {
        HttpClientBuilder2 builder = new HttpClientBuilder2();
        builder.setPreemptiveAuthentication(true);
        builder.setUsername(this.username);
        builder.setPassword(this.password);
        if (this.httpProxyHost != null) {
            Console.printLogMessage("Using Proxy Host : " + this.httpProxyHost);
            builder.setProxyHost(this.httpProxyHost);
        }
        if (this.httpProxyPort != 0) {
            Console.printLogMessage("Using Proxy Port : " + this.httpProxyPort);
            builder.setProxyPort(this.httpProxyPort);
        }
        ContentType contentType = ContentType.create((String)"application/octet-stream");
        FileEntity fileEntity = new FileEntity(versionZip, contentType);
        HttpPut put = new HttpPut(this.postUrl + FILE_SEPARATOR + this.versionName + ZIP_EXTENSION);
        put.addHeader("Content-Encoding", "application/octet-stream");
        put.setEntity((HttpEntity)fileEntity);
        Console.printLogMessage("Executing request " + put.getRequestLine());
        try (CloseableHttpClient client = builder.buildClient();){
            this.responseBody = (String)client.execute((HttpUriRequest)put, this.responseHandler);
        }
    }

    private void uploadToNexus(File versionZip) throws IOException {
        String auth = this.username + ":" + this.password;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        String authHeader = "Basic " + encodedAuth;
        HttpEntity data = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("raw.assetN", versionZip, ContentType.DEFAULT_BINARY, versionZip.getName()).addTextBody("raw.assetN.filename", this.versionName + ZIP_EXTENSION, ContentType.DEFAULT_TEXT).addTextBody("raw.directory", this.rawDirectory, ContentType.DEFAULT_TEXT).build();
        HttpUriRequest request = RequestBuilder.post((String)this.postUrl).setEntity(data).addHeader("Authorization", authHeader).build();
        Console.printLogMessage("Executing request " + request.getRequestLine());
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            this.responseBody = (String)httpClient.execute(request, this.responseHandler);
        }
    }
}

