/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import com.ibm.urbancode.zos.common.util.GenericHelper;
import com.ibm.urbancode.zos.common.util.SystemEnv;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class InstalledAgentVersion {
    private static final String TOOLKIT = "toolkit";
    private static final String INSTALLED_VERSION = "installed.version";
    private static final String CONF = "conf";
    private static final String PERIOD = "\\.";

    public static boolean isGreaterThanOrEqualTo(String agentVersionToCheck) throws IOException {
        return InstalledAgentVersion.isGreaterThanOrEqualTo(InstalledAgentVersion.getAgentToolkitVersion(), agentVersionToCheck);
    }

    protected static boolean isGreaterThanOrEqualTo(String agentVersion, String agentVersionToCheck) {
        String[] agentVersionBits = agentVersion.split(PERIOD);
        int versionNumber = Integer.parseInt(agentVersionBits[0]);
        int releaseNumber = Integer.parseInt(agentVersionBits[1]);
        int modificationNumber = Integer.parseInt(agentVersionBits[2]);
        String[] checkAgentVersionBits = agentVersionToCheck.split(PERIOD);
        int checkVersionNumber = Integer.parseInt(checkAgentVersionBits[0]);
        int checkReleaseNumber = Integer.parseInt(checkAgentVersionBits[1]);
        int checkModificationNumber = Integer.parseInt(checkAgentVersionBits[2]);
        if (versionNumber > checkVersionNumber) {
            return true;
        }
        if (versionNumber < checkVersionNumber) {
            return false;
        }
        if (releaseNumber > checkReleaseNumber) {
            return true;
        }
        if (releaseNumber < checkReleaseNumber) {
            return false;
        }
        return modificationNumber >= checkModificationNumber;
    }

    private static String getAgentToolkitVersion() throws IOException {
        String toolkitBinaryVersionFilePath = SystemEnv.getBuzToolkitHome() + File.separator + CONF + File.separator + TOOLKIT + File.separator + INSTALLED_VERSION;
        File toolkitBinaryVersionFile = new File(toolkitBinaryVersionFilePath);
        Properties toolkitProp = new Properties();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(toolkitBinaryVersionFile));){
            toolkitProp.load(bufferedReader);
        }
        String installedVersion = toolkitProp.getProperty(INSTALLED_VERSION);
        if (GenericHelper.isNullOrEmpty(installedVersion)) {
            throw new RuntimeException("Unable to get toolkit version");
        }
        return installedVersion;
    }
}

