/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.dataset.alloc;

import com.ibm.jzos.ZFile;
import com.ibm.urbancode.zos.dataset.alloc.AllocateCommand;

public class AllocateCommandBuilder {
    private String allocateCommand;
    private final String ddName = ZFile.allocDummyDDName();

    public AllocateCommandBuilder(String dsName) {
        this.allocateCommand = "alloc fi(" + this.ddName + ") da(" + dsName + ")";
    }

    public AllocateCommand build() {
        return new AllocateCommand(this);
    }

    public AllocateCommandBuilder withVolumeSerial(String volumeSerial) {
        this.allocateCommand = this.allocateCommand + (volumeSerial.isEmpty() ? "" : " vol(" + volumeSerial + ")");
        return this;
    }

    public AllocateCommandBuilder withSpace(String primaryQuantity, String secondaryQuantity) {
        this.allocateCommand = this.allocateCommand + " space(" + primaryQuantity + "," + secondaryQuantity + ")";
        return this;
    }

    public AllocateCommandBuilder withSpaceUnit(String spaceUnit, String recordLength) {
        this.allocateCommand = this.allocateCommand + (spaceUnit.equals("BLKS") ? " block(" + recordLength + ")" : " " + spaceUnit);
        return this;
    }

    public AllocateCommandBuilder withSpaceUnit(String spaceUnit) {
        this.allocateCommand = this.allocateCommand + " " + spaceUnit;
        return this;
    }

    public AllocateCommandBuilder withBlockSize(String blockSize) {
        this.allocateCommand = this.allocateCommand + (blockSize.isEmpty() ? "" : " blksize(" + blockSize + ")");
        return this;
    }

    public AllocateCommandBuilder withAvgRec(String avgRec) {
        this.allocateCommand = this.allocateCommand + (avgRec.isEmpty() ? "" : " avgrec(" + avgRec + ")");
        return this;
    }

    public AllocateCommandBuilder withDirectoryBlocks(String directoryBlocks) {
        this.allocateCommand = this.allocateCommand + " dir(" + directoryBlocks + ")";
        return this;
    }

    public AllocateCommandBuilder withRecordFormat(String recordFormat) {
        this.allocateCommand = this.allocateCommand + " recfm(" + recordFormat + ")";
        return this;
    }

    public AllocateCommandBuilder withRecordLength(String recordLength) {
        this.allocateCommand = this.allocateCommand + " lrecl(" + recordLength + ")";
        return this;
    }

    public AllocateCommandBuilder withDatasetType(String dsnType) {
        this.allocateCommand = this.allocateCommand + (dsnType.isEmpty() ? "" : " dsntype(" + dsnType + ")");
        return this;
    }

    public AllocateCommandBuilder withReuseNewCatalogDisposition() {
        this.allocateCommand = this.allocateCommand + " reuse new catalog msg(wtp)";
        return this;
    }

    public AllocateCommandBuilder withLikeDataset(String likeDatasetName) {
        this.allocateCommand = this.allocateCommand + " like(" + likeDatasetName + ")";
        return this;
    }

    public AllocateCommandBuilder withManagementClass(String managementClass) {
        this.allocateCommand = this.allocateCommand + (managementClass.isEmpty() ? "" : " MGMTCLAS(" + managementClass + ")");
        return this;
    }

    public AllocateCommandBuilder withStorageClass(String storageClass) {
        this.allocateCommand = this.allocateCommand + (storageClass.isEmpty() ? "" : " STORCLAS(" + storageClass + ")");
        return this;
    }

    public AllocateCommandBuilder withDataClass(String dataClass) {
        this.allocateCommand = this.allocateCommand + (dataClass.isEmpty() ? "" : " DATACLAS(" + dataClass + ")");
        return this;
    }

    public String getAllocateCommand() {
        return this.allocateCommand;
    }

    public String getDDName() {
        return this.ddName;
    }
}

