/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.generate.artifact.info;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class LoopType {
    private static final String DELETED = "deleted";
    public static final String MEMBER = "Member";
    public static final String PDS = "PDS";
    public static final String DELETED_MEMBER = "DeletedMember";
    public static final String DELETED_PDS = "DeletedPDS";
    public static final String SEQUENTIAL = "Sequential";
    public static final String DELETED_SEQUENTIAL = "DeletedSequential";
    public static final String DIRECTORY = "Directory";
    public static final String FILE = "File";
    public static final String DELETED_FILE = "DeletedFile";
    public static final String GENERIC_ARTIFACT_GROUP = "GenericArtifactGroup";
    public static final String GENERIC_ARTIFACT = "GenericArtifact";
    public static final String DELETED_MEMBER_EXCLUDING_MISSING_MEMBERS = "DeletedMemberExcludingMissingMembers";
    private static final String[] containerLevelsArray = new String[]{"PDS", "DeletedPDS", "Sequential", "DeletedSequential", "GenericArtifactGroup", "Directory"};
    private static final Set<String> containerLevels = new HashSet<String>(Arrays.asList(containerLevelsArray));
    private static final String[] resourceLevelsArray = new String[]{"Member", "DeletedMember", "DeletedMemberExcludingMissingMembers", "GenericArtifact", "File", "DeletedFile"};
    private static final Set<String> resourceLevels = new HashSet<String>(Arrays.asList(resourceLevelsArray));

    private LoopType() {
    }

    public static boolean isDeleted(String loopType) {
        return loopType.toLowerCase().contains(DELETED);
    }

    public static boolean isContainerLevel(String loopType) {
        return containerLevels.contains(loopType);
    }

    public static boolean isResourceLevel(String loopType) {
        return resourceLevels.contains(loopType);
    }
}

