/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import com.ibm.jzos.ZFile;
import com.ibm.urbancode.zos.dataset.util.ActionRecord;
import com.urbancode.air.plugin.inputs.DeleteDatasetInputs;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class DeleteActionRecordsLoader {
    private static final String SINGLE_QUOTE = "'";
    private final List<ActionRecord> actionRecords = new ArrayList<ActionRecord>();
    private final String datasets;
    private final String members;

    public DeleteActionRecordsLoader(DeleteDatasetInputs deleteDatasetInputs) {
        this.datasets = deleteDatasetInputs.getDatasets();
        this.members = deleteDatasetInputs.getMembers();
    }

    public void load() throws Exception {
        if (this.members.isEmpty()) {
            this.loadRecordsForEachDataset(this.datasets);
        } else {
            this.loadRecordsForDatasetForEachMember(this.datasets, this.members);
        }
    }

    private void loadRecordsForEachDataset(String datasets) throws Exception {
        try (BufferedReader bufferedReader = new BufferedReader(new StringReader(datasets));){
            String datasetLine;
            while ((datasetLine = bufferedReader.readLine()) != null) {
                if (datasetLine.trim().isEmpty()) continue;
                String qualifiedDataset = this.getFullyQualifiedDataset(datasetLine.trim());
                this.actionRecords.add(this.createActionRecordWithDataset(qualifiedDataset));
            }
        }
    }

    private ActionRecord createActionRecordWithDataset(String qualifiedDataset) {
        ActionRecord actionRecord = new ActionRecord("DELETE");
        if (DeleteActionRecordsLoader.isPdsWithMember(qualifiedDataset)) {
            int indexOfOpenParentheses = qualifiedDataset.indexOf("(");
            String dataset = qualifiedDataset.substring(0, indexOfOpenParentheses);
            String member = qualifiedDataset.substring(indexOfOpenParentheses + 1, qualifiedDataset.length() - 1);
            actionRecord.setTargetPdsWithMember(dataset, member);
        } else {
            actionRecord.setSequentialTargetDataset(qualifiedDataset);
        }
        return actionRecord;
    }

    private static boolean isPdsWithMember(String dataset) {
        return Pattern.matches(".+\\(.+\\)$", dataset);
    }

    private String getFullyQualifiedDataset(String inputDataset) {
        String datasetName = inputDataset.contains(SINGLE_QUOTE) ? DeleteActionRecordsLoader.removeSingleQuotes(inputDataset) : ZFile.getFullyQualifiedDSN((String)inputDataset);
        return datasetName;
    }

    private static String removeSingleQuotes(String dataset) {
        return dataset.replace(SINGLE_QUOTE, "");
    }

    private void loadRecordsForDatasetForEachMember(String dataset, String membersList) throws Exception {
        String qualifiedDataset = this.getFullyQualifiedDataset(dataset);
        try (BufferedReader reader = new BufferedReader(new StringReader(membersList));){
            String member;
            while ((member = reader.readLine()) != null) {
                if (member.trim().isEmpty()) continue;
                ActionRecord actionRecord = new ActionRecord("DELETE");
                actionRecord.setTargetPdsWithMember(qualifiedDataset, member.trim());
                this.actionRecords.add(actionRecord);
            }
        }
    }

    public List<ActionRecord> getActionRecords() {
        return this.actionRecords;
    }
}

