/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.dataset.util;

import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.dataset.util.DatasetLreclException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class RexxFileToDatasetConvertor {
    private static final int DATASET_LRECL = 80;
    private final String filePath;
    private final String dataset;

    public RexxFileToDatasetConvertor(String filePath, String dataset) {
        this.filePath = filePath;
        this.dataset = dataset;
    }

    public void convert() throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.filePath));){
            this.createDataset();
            this.writeRexxLinesToDataset(bufferedReader);
        }
        catch (Exception exception) {
            DatasetHelper.deleteDataset(this.dataset);
            throw exception;
        }
    }

    private void createDataset() {
        int spaceInTracks = DatasetHelper.determineDatasetSpace(this.filePath);
        String fullyQualifiedDsn = ZFile.getFullyQualifiedDSN((String)this.dataset, (boolean)true);
        String tempDD = ZFile.allocDummyDDName();
        ZFile.bpxwdyn((String)("alloc fi(" + tempDD + ") da(" + fullyQualifiedDsn + ") dsorg(ps) lrecl(" + 80 + ") recfm(f,b) tracks space(" + spaceInTracks + "," + spaceInTracks + ") blksize(" + 800 + ") reuse new catalog msg(wtp)"));
        ZFile.bpxwdyn((String)("free fi(" + tempDD + ") msg(wtp)"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRexxLinesToDataset(BufferedReader bufferedReader) throws IOException {
        RecordWriter recordWriter = null;
        try {
            String line;
            recordWriter = RecordWriter.newWriter((String)ZFile.getSlashSlashQuotedDSN((String)this.dataset, (boolean)true), (int)1);
            int lineCount = 0;
            while ((line = bufferedReader.readLine()) != null) {
                this.writeRecord(recordWriter, line, lineCount++);
            }
        }
        finally {
            if (recordWriter != null) {
                recordWriter.close();
                recordWriter.flush();
            }
        }
    }

    private void writeRecord(RecordWriter recordWriter, String line, int lineNo) throws IOException {
        String record = String.format("%-80s", line);
        byte[] recBuf = record.getBytes(ZUtil.getDefaultPlatformEncoding());
        if (recBuf.length > 80) {
            throw new DatasetLreclException(" [ERROR] Line number " + lineNo + " in input text exceeds available record length of dataset " + 80);
        }
        recordWriter.write(recBuf, 0, recBuf.length);
    }
}

