/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.inputs;

import com.urbancode.air.plugin.inputs.InputsValidator;
import java.util.Properties;

public class TsoIspfInputs {
    public static final String COMMANDS = "tsoCommand";
    public static final String ISPF_GATEWAY_PATH = "ispfGatewayPath";
    public static final String STOP_ON_FAIL = "stopOnFail";
    public static final String REUSE_SESSION = "reuseSession";
    public static final String SHOW_LOG = "showLog";
    public static final String SERVICE_TYPE = "serviceType";
    public static final String ISP_PROF = "ispProf";
    private final String commands;
    private final String ispfGatewayPath;
    private final boolean isStopOnFailSet;
    private final boolean isReuseSessionSet;
    private final boolean isShowLogSet;
    private final String serviceType;
    private final String ispProf;

    public TsoIspfInputs(Properties inputProperties) {
        this.commands = inputProperties.getProperty(COMMANDS).trim();
        this.ispfGatewayPath = inputProperties.getProperty(ISPF_GATEWAY_PATH).trim();
        this.isStopOnFailSet = Boolean.parseBoolean(inputProperties.getProperty(STOP_ON_FAIL));
        this.isReuseSessionSet = Boolean.parseBoolean(inputProperties.getProperty(REUSE_SESSION));
        this.isShowLogSet = Boolean.parseBoolean(inputProperties.getProperty(SHOW_LOG));
        this.serviceType = inputProperties.getProperty(SERVICE_TYPE).trim();
        this.ispProf = inputProperties.getProperty(ISP_PROF).trim();
    }

    public void validate() {
        InputsValidator.checkIfEmpty(this.commands, "TSO and ISPF commands");
        InputsValidator.checkIfEmpty(this.ispfGatewayPath, "ISPF Gateway Path");
    }

    public String getCommands() {
        return this.commands;
    }

    public String getIspfGatewayPath() {
        return this.ispfGatewayPath;
    }

    public boolean isStopOnFailSet() {
        return this.isStopOnFailSet;
    }

    public boolean isReuseSessionSet() {
        return this.isReuseSessionSet;
    }

    public boolean isShowLogSet() {
        return this.isShowLogSet;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getIspProf() {
        return this.ispProf;
    }
}

