/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.packaging.common;

import com.ibm.urbancode.zos.packaging.common.EmptyInputException;
import com.ibm.urbancode.zos.packaging.common.FileHelper;
import com.ibm.urbancode.zos.packaging.common.FileNotExistException;
import com.ibm.urbancode.zos.packaging.common.InvalidBooleanException;
import java.io.File;

public final class InputValidator {
    private InputValidator() {
    }

    public static void validateInputFile(String fileName, String filePath) {
        InputValidator.checkIfFileExist(fileName, filePath);
        FileHelper.checkFilePermissions(filePath, "READ");
    }

    private static void checkIfFileExist(String fileName, String filePath) {
        if (!new File(filePath).exists()) {
            throw new FileNotExistException(fileName + " does not exist - " + filePath + "\nINFO: A sample " + fileName + " is available under agents 'zossamples' directory");
        }
    }

    public static void validateBooleanString(String inputName, String inputValue) {
        if (!inputValue.equalsIgnoreCase("TRUE") && !inputValue.equalsIgnoreCase("FALSE")) {
            throw new InvalidBooleanException("Invalid " + inputName + " " + inputValue + "\nValid values of " + inputName + " are TRUE (or) FALSE.");
        }
    }

    public static void validateForEmpty(String inputName, String inputValue) {
        if (inputValue.isEmpty()) {
            throw new EmptyInputException(inputName + " is empty.");
        }
    }
}

