/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.zinventory;

import com.ibm.urbancode.zos.common.util.DeploymentXmlFilePaths;
import com.ibm.urbancode.zos.deploy.xml.utils.ContainerResource;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.ContainerMapperParser;
import com.ibm.urbancode.zos.deploy.xml.utils.parsers.PackageManifestParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.codehaus.jettison.json.JSONObject;

public class ZInventoryRequestGenerator {
    private static final String PDS_MEMBER = "PDSMEMBER";
    private static final String DIRECTORY = "directory";
    private static final String USS_FILE = "USSFILE";
    private static final String SEQUENTIAL = "SEQUENTIAL";
    private static final String DELETED = "DELETE";
    private static final String DEPLOY = "DEPLOY";
    private static final String NAME = "name";
    private static final String INPUTS = "inputs";
    private static final String DEPLOY_TYPE = "deploy-type";
    private static final String TARGET_TYPE = "target-type";
    private static final String TARGET = "target";
    private static final String OPERATION_TYPE = "operation-type";
    private static final String PDS = "PDS";
    private static final String FORWARD_SLASH = "/";
    private static final String DELETE = "_DELETE";
    private final String containerMapperXml;
    private final String containerMapperHFSXml;
    private final String packageManifestDeployXml;
    private final String originalPackageManifest;
    private Map<String, String> pdsContainerMapper;
    private Map<String, String> dirContainerMapper;
    private final ArrayList<JSONObject> resourcesList = new ArrayList();
    private Set<ManifestContainer> deployedDatasets;
    private Set<ManifestContainer> originalPackageManifestContainers;
    private final HashMap<String, ManifestContainer> datasetMapper = new HashMap();

    public ZInventoryRequestGenerator() {
        this.containerMapperXml = DeploymentXmlFilePaths.containerMapperXmlFilePath;
        this.containerMapperHFSXml = DeploymentXmlFilePaths.containerMapperHFSXmlFilePath;
        this.packageManifestDeployXml = DeploymentXmlFilePaths.packageManifestFileDeployNamePath;
        this.originalPackageManifest = DeploymentXmlFilePaths.originalPackageManifestFileNamePath;
    }

    public void extractDataFromXmlFiles() throws IOException, XMLStreamException {
        try (FileInputStream packageManifestInputStream = new FileInputStream(this.packageManifestDeployXml);){
            this.deployedDatasets = new PackageManifestParser((InputStream)packageManifestInputStream).parse();
        }
        var2_2 = null;
        try (FileInputStream originalPackageManifestStream = new FileInputStream(this.originalPackageManifest);){
            this.originalPackageManifestContainers = new PackageManifestParser((InputStream)originalPackageManifestStream).parse();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        if (null != this.containerMapperXml && new File(this.containerMapperXml).isFile()) {
            var2_2 = null;
            try (FileInputStream containerMapperInputStream = new FileInputStream(this.containerMapperXml);){
                this.pdsContainerMapper = new ContainerMapperParser((InputStream)containerMapperInputStream).parse();
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
        }
        if (null != this.containerMapperHFSXml && new File(this.containerMapperHFSXml).isFile()) {
            var2_2 = null;
            try (FileInputStream containerMapperHfsInputStream = new FileInputStream(this.containerMapperHFSXml);){
                this.dirContainerMapper = new ContainerMapperParser((InputStream)containerMapperHfsInputStream).parse();
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
        }
    }

    public List<JSONObject> buildRequestPayload() throws XMLStreamException, IOException {
        this.extractDataFromXmlFiles();
        this.mapDatasetNameWithDatasetObjectFromOriginalPackageManifest();
        try {
            for (ManifestContainer dataset : this.deployedDatasets) {
                String operationType;
                ManifestContainer ds;
                if (dataset.isDeleted()) {
                    ds = this.datasetMapper.get(dataset.getName() + DELETE);
                    operationType = DELETED;
                } else {
                    ds = this.datasetMapper.get(dataset.getName());
                    operationType = DEPLOY;
                }
                if (!ds.getContainerResources().isEmpty()) {
                    for (ContainerResource mem : ds.getContainerResources()) {
                        JSONObject js = new JSONObject();
                        js.put(NAME, (Object)mem.getName());
                        js.put(INPUTS, (Object)mem.getInputs().getInputsForZSearch());
                        js.put(OPERATION_TYPE, (Object)operationType);
                        js.put(DEPLOY_TYPE, (Object)(mem.getDeployType() == null ? "" : mem.getDeployType()));
                        if (ds.getType().equalsIgnoreCase(PDS)) {
                            js.put(TARGET_TYPE, (Object)PDS_MEMBER);
                            js.put(TARGET, (Object)this.pdsContainerMapper.get(ds.getName()));
                        } else if (ds.getType().equalsIgnoreCase(DIRECTORY)) {
                            js.put(TARGET_TYPE, (Object)USS_FILE);
                            js.put(TARGET, (Object)this.dirContainerMapper.get(FORWARD_SLASH + ds.getName()));
                        }
                        this.resourcesList.add(js);
                    }
                    continue;
                }
                if (!ds.getType().equalsIgnoreCase(SEQUENTIAL)) continue;
                JSONObject js = new JSONObject();
                js.put(TARGET_TYPE, (Object)SEQUENTIAL);
                js.put(TARGET, (Object)this.pdsContainerMapper.get(ds.getName()));
                js.put(INPUTS, (Object)ds.getInputs().getInputsForZSearch());
                js.put(NAME, (Object)ds.getName());
                js.put(DEPLOY_TYPE, (Object)(ds.getDeployType() == null ? "" : ds.getDeployType()));
                js.put(OPERATION_TYPE, (Object)operationType);
                this.resourcesList.add(js);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.resourcesList;
    }

    private void mapDatasetNameWithDatasetObjectFromOriginalPackageManifest() {
        for (ManifestContainer ds : this.originalPackageManifestContainers) {
            if (ds.isDeleted()) {
                this.datasetMapper.put(ds.getName() + DELETE, ds);
                continue;
            }
            this.datasetMapper.put(ds.getName(), ds);
        }
    }
}

