/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.generate.artifact.info;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

public class CustomProperties {
    private static final char PROPERTY_SEPARATOR = '=';
    private static final String EMPTY_STRING = "";
    private static final String REGEX_FOR_PROPERTY = ".+=.*";
    private final String customProperties;
    Map<String, String> map = new HashMap<String, String>();

    public CustomProperties(String customProperties) {
        this.customProperties = customProperties;
    }

    public Map<String, String> loadIntoMap() {
        try (BufferedReader reader = new BufferedReader(new StringReader(this.customProperties));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                this.loadPropertyIntoMap(line);
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException("Failed to read custom properties");
        }
        return this.map;
    }

    private void loadPropertyIntoMap(String line) {
        if (this.isInvalidProperty(line)) {
            throw new IllegalArgumentException("Invalid Custom property found - " + line);
        }
        int separatorIndex = line.indexOf(61);
        String propertyName = line.substring(0, separatorIndex).trim();
        String propertyValue = this.isPropertyValueEmpty(line) ? EMPTY_STRING : line.substring(separatorIndex + 1);
        this.map.put(propertyName, propertyValue);
    }

    private boolean isInvalidProperty(String line) {
        return !line.matches(REGEX_FOR_PROPERTY);
    }

    private boolean isPropertyValueEmpty(String line) {
        int lastIndex = line.length() - 1;
        return line.indexOf(61) == lastIndex;
    }
}

