/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.generate.artifact.info;

import java.util.HashMap;
import java.util.Map;

public final class InfoMatcher {
    private static final String REGEX_FORMAT = "^/.+/$";
    public static final String CONTAINER_TYPE_PDS = "PDS";
    public static final String CONTAINER_TYPE_SEQUENTIAL = "sequential";
    public static final String CONTAINER_TYPE_DIRECTORY = "directory";
    public static final String CONTAINER_TYPE_GENERIC = "GENERIC";
    private static final Map<String, String> loopTypeToContainerTypeMap = new HashMap<String, String>(){
        {
            this.put("Member", InfoMatcher.CONTAINER_TYPE_PDS);
            this.put(InfoMatcher.CONTAINER_TYPE_PDS, InfoMatcher.CONTAINER_TYPE_PDS);
            this.put("DeletedMember", InfoMatcher.CONTAINER_TYPE_PDS);
            this.put("DeletedPDS", InfoMatcher.CONTAINER_TYPE_PDS);
            this.put("DeletedMemberExcludingMissingMembers", InfoMatcher.CONTAINER_TYPE_PDS);
            this.put("Sequential", InfoMatcher.CONTAINER_TYPE_SEQUENTIAL);
            this.put("DeletedSequential", InfoMatcher.CONTAINER_TYPE_SEQUENTIAL);
            this.put("Directory", InfoMatcher.CONTAINER_TYPE_DIRECTORY);
            this.put("File", InfoMatcher.CONTAINER_TYPE_DIRECTORY);
            this.put("DeletedFile", InfoMatcher.CONTAINER_TYPE_DIRECTORY);
            this.put("GenericArtifactGroup", InfoMatcher.CONTAINER_TYPE_GENERIC);
            this.put("GenericArtifact", InfoMatcher.CONTAINER_TYPE_GENERIC);
        }
    };

    private InfoMatcher() {
    }

    public static boolean isMatched(String filter, String value) {
        if (filter.isEmpty()) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return InfoMatcher.isFilterValueMatched(filter, value);
    }

    private static boolean isFilterValueMatched(String filter, String value) {
        if (InfoMatcher.isFilterARegularExpression(filter)) {
            String pattern = InfoMatcher.extractPatternFromRegEx(filter);
            return value.matches(pattern);
        }
        return value.equals(filter);
    }

    public static boolean isPropertyMatched(String filterPropertyKey, String filterPropertyValue, Map<String, String> customProperties) {
        if (!customProperties.containsKey(filterPropertyKey)) {
            return false;
        }
        if (filterPropertyValue.isEmpty()) {
            return true;
        }
        String custValue = customProperties.get(filterPropertyKey);
        return InfoMatcher.isFilterValueMatched(filterPropertyValue, custValue);
    }

    public static boolean isContainerTypeCompatibleWithLoopType(String containerType, String loopType) {
        return containerType.equalsIgnoreCase(loopTypeToContainerTypeMap.get(loopType));
    }

    private static boolean isFilterARegularExpression(String inputFilter) {
        return inputFilter.matches(REGEX_FORMAT);
    }

    private static String extractPatternFromRegEx(String regEx) {
        return regEx.substring(1, regEx.length() - 1);
    }
}

