/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ProcessExecutor {
    private final ProcessBuilder processBuilder;
    private int result;
    private final StringBuilder stringBuilder = new StringBuilder();

    public ProcessExecutor(ProcessBuilder processBuilder) {
        this.processBuilder = processBuilder;
    }

    public int execute() throws IOException, InterruptedException {
        Process process = this.processBuilder.start();
        process.waitFor();
        this.addStreamToStringBuilder(process.getInputStream());
        this.result = process.exitValue();
        if (this.result != 0) {
            this.addStreamToStringBuilder(process.getErrorStream());
        }
        return this.result;
    }

    private void addStreamToStringBuilder(InputStream inputStream) throws IOException {
        if (inputStream.available() > 0) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.stringBuilder.append(line).append("\n");
                }
            }
        }
    }

    public String getProcessOutput() {
        return this.stringBuilder.toString();
    }

    public int getExitCode() {
        return this.result;
    }

    public String getProcessArguments() {
        return this.processBuilder.command().toString();
    }
}

