/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.zinventory;

import com.ibm.urbancode.zos.common.util.ServerAPIServicesHelper;
import com.ibm.urbancode.zos.zinventory.TimeTracker;
import com.ibm.urbancode.zos.zinventory.ZInventoryRequestGenerator;
import com.urbancode.air.plugin.inputs.DeployPackageInputs;
import com.urbancode.air.plugin.inputs.RollbackPackageInputs;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ZInventoryHandler {
    public static final String ENVIRONMENT = "environment";
    public static final String VERSION = "version";
    private static final String DEPLOY_TIME = "deploy-time";
    public static final String RESOURCES = "resources";
    private final String environmentId;
    private final String versionId;
    private TimeTracker timeTracker;
    private final boolean isDeploy;

    public ZInventoryHandler(DeployPackageInputs pluginInputs, TimeTracker timeTracker) {
        this.versionId = pluginInputs.getVersionId();
        this.environmentId = pluginInputs.getEnvironmentId();
        this.timeTracker = timeTracker;
        this.isDeploy = true;
    }

    public ZInventoryHandler(RollbackPackageInputs pluginInputs) {
        this.versionId = pluginInputs.getVersionId();
        this.environmentId = pluginInputs.getEnvironmentId();
        this.isDeploy = false;
    }

    public void updateZInventoryTable() throws JSONException, XMLStreamException, IOException, URISyntaxException {
        ServerAPIServicesHelper serverConn = new ServerAPIServicesHelper();
        if (this.isDeploy) {
            JSONObject request = this.buildJsonRequest();
            serverConn.addDeploymentDataToZInventoryTable(request.toString());
        } else {
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add((NameValuePair)new BasicNameValuePair(ENVIRONMENT, this.environmentId));
            params.add((NameValuePair)new BasicNameValuePair(VERSION, this.versionId));
            serverConn.rollbackDataInZInventoryTable(params);
        }
    }

    private JSONObject buildJsonRequest() throws JSONException, XMLStreamException, IOException {
        JSONObject requestBody = new JSONObject();
        this.populateRequestBodyWithGenericData(requestBody);
        this.populateRequestBodyWithDeployedArtifactDetails(requestBody);
        return requestBody;
    }

    private void populateRequestBodyWithGenericData(JSONObject requestBody) throws JSONException, IOException {
        requestBody.put(ENVIRONMENT, (Object)this.environmentId);
        requestBody.put(VERSION, (Object)this.versionId);
        requestBody.put(DEPLOY_TIME, this.timeTracker.getDeployTime());
    }

    private void populateRequestBodyWithDeployedArtifactDetails(JSONObject requestBody) throws JSONException, XMLStreamException, IOException {
        ZInventoryRequestGenerator zInventoryRequestGenerator = new ZInventoryRequestGenerator();
        List<JSONObject> resources = zInventoryRequestGenerator.buildRequestPayload();
        requestBody.put(RESOURCES, resources);
    }
}

