/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.common.util.MVSHelper;
import com.ibm.urbancode.zos.dataset.alloc.AllocateCommand;
import com.ibm.urbancode.zos.dataset.alloc.AllocateCommandBuilder;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.urbancode.air.plugin.inputs.AllocateLikeInputs;
import java.util.Properties;

public class AllocateLike {
    public static final String OUTPUT_PROPERTY_DATASET_NAME = "DatasetName";
    private static final String SPACE_UNIT_BLOCKS = "BLKS";
    private final Properties inputProperties;
    private final Properties outputProperties;

    public AllocateLike(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            AllocateLikeInputs pluginInputs = new AllocateLikeInputs(this.inputProperties);
            pluginInputs.validate();
            if (pluginInputs.isDeleteDatasetEnabled()) {
                DatasetHelper.deleteDataset(pluginInputs.getDatasetName());
            }
            AllocateCommand allocateCommand = this.getAllocateCommand(pluginInputs);
            allocateCommand.execute();
            String actualDatasetName = DatasetHelper.isGDGDatasetWithReference(pluginInputs.getDatasetName()) ? MVSHelper.getGDGNameAssignedToDD(allocateCommand.getDDName()) : pluginInputs.getDatasetName();
            allocateCommand.freeDDName();
            System.out.println(" [INFO] Dataset " + actualDatasetName + " is created.");
            this.outputProperties.put(OUTPUT_PROPERTY_DATASET_NAME, actualDatasetName);
            return 0;
        }
        catch (RuntimeException runtimeException) {
            System.out.println(" [Error] " + runtimeException.getMessage());
        }
        catch (ZFileException zFileException) {
            throw new RuntimeException(zFileException);
        }
        return 1;
    }

    private AllocateCommand getAllocateCommand(AllocateLikeInputs pluginInputs) throws ZFileException {
        String likeDatasetName = DatasetHelper.isGDGDatasetWithReference(pluginInputs.getLikeDatasetName()) ? MVSHelper.getGDGNameFromDataset(pluginInputs.getLikeDatasetName()) : pluginInputs.getLikeDatasetName();
        AllocateCommandBuilder allocateCommandBuilder = new AllocateCommandBuilder(pluginInputs.getDatasetName()).withLikeDataset(likeDatasetName).withVolumeSerial(pluginInputs.getVolumeSerial());
        if (this.containsPrimarySecondarySpaceQuantity(pluginInputs)) {
            allocateCommandBuilder = allocateCommandBuilder.withSpace(pluginInputs.getPrimaryQuantity(), pluginInputs.getSecondaryQuantity());
            if (this.isSpaceNotInBlocks(pluginInputs.getSpaceUnit())) {
                allocateCommandBuilder = allocateCommandBuilder.withSpaceUnit(pluginInputs.getSpaceUnit());
            }
        }
        allocateCommandBuilder = allocateCommandBuilder.withReuseNewCatalogDisposition();
        return allocateCommandBuilder.build();
    }

    private boolean containsPrimarySecondarySpaceQuantity(AllocateLikeInputs pluginInputs) {
        return !pluginInputs.getPrimaryQuantity().isEmpty() && !pluginInputs.getSecondaryQuantity().isEmpty();
    }

    private boolean isSpaceNotInBlocks(String spaceUnit) {
        return !spaceUnit.equals(SPACE_UNIT_BLOCKS);
    }
}

