/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.xml.utils;

import com.ibm.urbancode.zos.deploy.xml.utils.ContainerResource;
import com.ibm.urbancode.zos.deploy.xml.utils.ContainerType;
import com.ibm.urbancode.zos.deploy.xml.utils.Inputs;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ManifestContainer
implements Comparable<ManifestContainer> {
    private String targetContainerName;
    private String deployType;
    private final Set<ContainerResource> containerResources = new LinkedHashSet<ContainerResource>();
    private final Map<String, String> customerProperties = new HashMap<String, String>();
    private boolean isDeleted = false;
    private Inputs inputs;
    private boolean isMissing = false;
    private final String sourceContainerName;
    private final ContainerType type;

    public ManifestContainer(String sourceContainerName, ContainerType type) {
        this.sourceContainerName = sourceContainerName;
        this.targetContainerName = sourceContainerName;
        this.type = type;
    }

    public Inputs getInputs() {
        if (this.inputs == null) {
            this.inputs = new Inputs();
        }
        return this.inputs;
    }

    public void addContainerResource(ContainerResource containerResource) {
        this.containerResources.add(containerResource);
    }

    public Set<ContainerResource> getContainerResources() {
        return this.containerResources;
    }

    public String getTargetContainerName() {
        return this.targetContainerName;
    }

    public void setTargetContainerName(String targetContainerName) {
        this.targetContainerName = targetContainerName;
    }

    public String getDeployType() {
        return this.deployType;
    }

    public void setDeployType(String deployType) {
        this.deployType = deployType;
    }

    public Map<String, String> getCustomerProperties() {
        return this.customerProperties;
    }

    public void addCustomerProperty(String property, String value) {
        this.customerProperties.put(property, value);
    }

    public String getSourceContainerName() {
        return this.sourceContainerName;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted() {
        this.isDeleted = true;
    }

    public ContainerType getType() {
        return this.type;
    }

    public boolean isGeneric() {
        return this.type == ContainerType.GENERIC;
    }

    public boolean isDirectory() {
        return this.type == ContainerType.DIRECTORY;
    }

    public boolean isPds() {
        return this.type == ContainerType.PDS;
    }

    public boolean isSequential() {
        return this.type == ContainerType.SEQUENTIAL;
    }

    public void setMissing() {
        this.isMissing = true;
    }

    public boolean isMissing() {
        return this.isMissing;
    }

    @Override
    public int compareTo(ManifestContainer other) {
        return this.sourceContainerName.compareTo(other.getSourceContainerName());
    }

    public String toString() {
        return "ManifestContainer{sourceContainerName='" + this.sourceContainerName + '\'' + ", type='" + this.type.toString() + '\'' + ", delete=" + this.isDeleted + ", targetContainerName='" + this.targetContainerName + '\'' + ", deployType='" + this.deployType + '\'' + ", containerResources=" + this.containerResources + ", customerProperties=" + this.customerProperties + ", inputs=" + this.inputs + '}';
    }
}

