/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.zos.sdsf.core.ISFRequestResults;
import com.ibm.zos.sdsf.core.ISFRequestSettings;
import com.ibm.zos.sdsf.core.ISFRunner;
import java.util.List;

public class MVSHelper {
    final int MAX_USERID_LENGTH = 8;
    final int MAX_COMMAND_LENGTH = 126;
    private final String sdsfLibraryPath;
    private int returnCode = 0;
    private ISFRunner runner = null;
    private ISFRequestResults results = null;

    public MVSHelper(String sdsfLibraryPath) {
        this.sdsfLibraryPath = sdsfLibraryPath;
    }

    public static String getGDGNameAssignedToDD(String ddName) throws ZFileException {
        String datasetName;
        String slashSlashDDName = "//DD:" + ddName;
        try (ZFile zFile = null;){
            zFile = new ZFile(slashSlashDDName, "rb");
            datasetName = zFile.getActualFilename();
        }
        return datasetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGDGNameFromDataset(String datasetName) throws ZFileException {
        String actualName;
        String ddName = ZFile.allocDummyDDName();
        String allocCommand = "alloc fi(" + ddName + ") da(" + datasetName + ") reuse shr msg(wtp)";
        ZFile.bpxwdyn((String)allocCommand);
        try {
            actualName = MVSHelper.getGDGNameAssignedToDD(ddName);
        }
        finally {
            ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
        }
        return actualName;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public ISFRequestResults getResults() {
        return this.results;
    }

    private void createRunner() {
        if (this.runner == null) {
            ISFRequestSettings settings = new ISFRequestSettings();
            StringBuilder sb = new StringBuilder(System.getProperty("user.name"));
            if (sb.length() < 8) {
                sb.append("x");
            }
            settings.addISFCons(sb.toString());
            this.runner = new ISFRunner(settings);
        }
    }

    public void runCommand(String mvsCommand) {
        if (mvsCommand.length() > 126) {
            System.out.println("Command exceeded 126 bytes");
            this.returnCode = 100;
        } else {
            this.createRunner();
            System.out.println("===============================");
            System.out.println(mvsCommand);
            this.returnCode = this.runner.system(mvsCommand);
            System.out.println("ReturnCode = " + this.returnCode);
            this.results = this.runner.getRequestResults();
            if (this.returnCode > 0) {
                System.out.println("ReasonCode = " + this.results.getReasonCode());
                this.results.printMessageList();
            }
            this.results.printResponseList();
        }
    }

    public boolean verifySDSF() {
        System.setProperty("java.library.path", this.sdsfLibraryPath + ":" + System.getProperty("java.library.path"));
        this.createRunner();
        int code = this.runner.queryAuth();
        if (code != 0) {
            System.out.println("Failed to run QUERY AUTH in SDSF. You must be authorized to use SDSF from Java and you must be authorized to the SDSF functions that you invoke from Java.");
            return false;
        }
        ISFRequestResults r = this.runner.getRequestResults();
        List msgList = r.getMessageList();
        boolean canUseLog = msgList.contains("ISF444I ULOG");
        if (!canUseLog) {
            System.out.println("Warning: User " + System.getProperty("user.name") + " is not authorized to use ULOG command from SDSF Java interface. ");
            System.out.println("Warning: You may issue MVS commands but may not see the response of the commands.");
            System.out.println("Warning: RACF resource ISFCMD.ODSP.ULOG.jesx CL(SDSF) gives user authority to issue the ULOG command.");
        }
        return true;
    }
}

