/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.xml.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ManifestVersion {
    private static final String ENCODING_CP037 = "CP037";
    private static final String MANIFEST_NODE = "manifest";
    private static final String MANIFEST_VERSION_ATTRIBUTE = "version";
    private static final String V_2_0 = "v2_0";

    private ManifestVersion() {
    }

    public static boolean isV2(String manifestPath) throws XMLStreamException, IOException {
        return ManifestVersion.isV2(manifestPath, ENCODING_CP037);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isV2(String manifestPath, String encoding) throws XMLStreamException, IOException {
        boolean isNewPackage = false;
        try (FileInputStream shipListFileStream = new FileInputStream(manifestPath);){
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            try (XMLEventReader eventReader = null;){
                eventReader = inputFactory.createXMLEventReader(shipListFileStream, encoding);
                while (eventReader.hasNext()) {
                    StartElement startElement;
                    String nodeName;
                    XMLEvent shipListReaderEvent = eventReader.nextEvent();
                    if (shipListReaderEvent.getEventType() != 1 || !MANIFEST_NODE.equalsIgnoreCase(nodeName = (startElement = shipListReaderEvent.asStartElement()).getName().getLocalPart().trim())) continue;
                    String versionValue = ManifestVersion.getAttributeValue(startElement);
                    isNewPackage = versionValue != null && versionValue.equals(V_2_0);
                    break;
                }
            }
        }
        return isNewPackage;
    }

    private static String getAttributeValue(StartElement startElement) {
        Iterator<Attribute> it = startElement.getAttributes();
        while (it.hasNext()) {
            Attribute attr = it.next();
            if (!attr.getName().getLocalPart().equals(MANIFEST_VERSION_ATTRIBUTE)) continue;
            return attr.getValue();
        }
        return null;
    }
}

