/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.inputs;

import com.ibm.urbancode.zos.generate.artifact.info.DeploymentAction;
import com.ibm.urbancode.zos.generate.artifact.info.FilterInputs;
import com.ibm.urbancode.zos.generate.artifact.info.LoopType;
import com.urbancode.air.plugin.inputs.InputsValidator;
import com.urbancode.air.plugin.inputs.InvalidInputException;
import java.util.Properties;

public class GenerateInfoInputs {
    public static final String LOOP_TYPE = "loopType";
    public static final String DEPLOY_TYPE_NAME = "deployTypeName";
    public static final String SRC_DATASET_NAME = "srcDatasetName";
    public static final String DATASET_NAME = "datasetName";
    public static final String MEMBER_NAME = "memberName";
    public static final String CUST_PROPERTIES = "custProperties";
    public static final String TEMPLATE_TEXT = "templateText";
    public static final String ORDER_BY = "orderBy";
    public static final String FAIL_ON_EMPTY = "failOnEmpty";
    public static final String IGNORE_UNRESOLVED = "ignoreUnresolved";
    public static final String DEPLOY_BASE_PATH = "deployBasePath";
    public static final String COMPONENT_NAME = "componentName";
    public static final String VERSION_NAME = "versionName";
    public static final String RESOURCE_ID = "resourceId";
    public static final String DEPLOY_ACTION = "deployAction";
    private static final String ESCAPED_NEW_LINE = "\\n";
    private static final String NEW_LINE = "\n";
    private final String deployBasePath;
    private final String componentName;
    private final String versionName;
    private final String resourceId;
    private final boolean failOnEmpty;
    private final FilterInputs filterInputs = new FilterInputs();

    public GenerateInfoInputs(Properties inputProperties) {
        String loopType = inputProperties.getProperty(LOOP_TYPE);
        String deployTypeName = inputProperties.getProperty(DEPLOY_TYPE_NAME).trim();
        String srcDatasetName = inputProperties.getProperty(SRC_DATASET_NAME).trim();
        String targetDatasetName = inputProperties.getProperty(DATASET_NAME).trim();
        String memberName = inputProperties.getProperty(MEMBER_NAME).trim();
        String custProperties = inputProperties.getProperty(CUST_PROPERTIES).trim();
        String inputTemplate = inputProperties.getProperty(TEMPLATE_TEXT);
        String template = inputTemplate.replace(ESCAPED_NEW_LINE, NEW_LINE);
        String orderBy = inputProperties.getProperty(ORDER_BY);
        this.failOnEmpty = Boolean.parseBoolean(inputProperties.getProperty(FAIL_ON_EMPTY));
        boolean ignoreUnresolved = Boolean.parseBoolean(inputProperties.getProperty(IGNORE_UNRESOLVED));
        String deployAction = inputProperties.getProperty(DEPLOY_ACTION).trim().toLowerCase();
        this.deployBasePath = inputProperties.getProperty(DEPLOY_BASE_PATH).trim();
        this.componentName = inputProperties.getProperty(COMPONENT_NAME).trim();
        this.versionName = inputProperties.getProperty(VERSION_NAME).trim();
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
        this.filterInputs.setOrderBy(orderBy);
        this.filterInputs.setLoopType(loopType);
        this.filterInputs.setSourceDataset(srcDatasetName);
        this.filterInputs.setTargetDataset(targetDatasetName);
        this.filterInputs.setDeployType(deployTypeName);
        this.filterInputs.setMember(memberName);
        if (ignoreUnresolved) {
            this.filterInputs.setIgnoreUnresolved();
        }
        this.filterInputs.setCustomProperties(custProperties);
        this.filterInputs.setTemplate(template);
        this.filterInputs.setDeployAction(deployAction);
    }

    public void validateInputs() {
        InputsValidator.checkIfEmpty(this.componentName, "Component Name");
        InputsValidator.checkIfEmpty(this.deployBasePath, "Deploy Base Path");
        InputsValidator.checkIfEmpty(this.versionName, "Version Name");
        InputsValidator.checkIfEmpty(this.resourceId, "Resource Id");
        InputsValidator.checkIfEmpty(this.filterInputs.getTemplate().trim(), "Template");
        if (this.filterInputs.isDeployActionPassed()) {
            this.validateDeploymentAction();
        }
        if (!this.filterInputs.getTargetDataset().isEmpty() && !LoopType.isDatasetLevel((String)this.filterInputs.getLoopType())) {
            throw new InvalidInputException("Target Dataset Filter is applicable for only dataset/member loop types.");
        }
    }

    private void validateDeploymentAction() {
        if (DeploymentAction.isUnsupportedLoopType((String)this.filterInputs.getLoopType())) {
            throw new InvalidInputException("Unsupported Loop Type '" + this.filterInputs.getLoopType() + "' found with deployment action. Deployment Action is supported for Loop Types - 'Sequential' or 'PDS Member'");
        }
        if (DeploymentAction.isInvalid((String)this.filterInputs.getDeployAction())) {
            throw new InvalidInputException("ERROR: Invalid Deployment Action Filter '" + this.filterInputs.getDeployAction() + "'.Deployment Action can be either " + "created" + " (or) " + "updated");
        }
    }

    public String getDeployBasePath() {
        return this.deployBasePath;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public boolean isFailOnEmpty() {
        return this.failOnEmpty;
    }

    public FilterInputs getFilterInputs() {
        return this.filterInputs;
    }
}

