/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.packaging.common;

import com.ibm.urbancode.zos.packaging.common.InsufficientFilePermissionsException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class FileHelper {
    public static final String PERMISSION_READ = "READ";
    public static final String PERMISSION_WRITE = "WRITE";

    public static void checkFilePermissions(String filePath, String permission) {
        File file = new File(filePath);
        if (permission.equals(PERMISSION_READ) && !file.canRead()) {
            throw new InsufficientFilePermissionsException("User does not have READ permission to " + file + " - " + filePath);
        }
        if (permission.equals(PERMISSION_WRITE) && !file.canWrite()) {
            throw new InsufficientFilePermissionsException("User does not have WRITE permission to " + file + " - " + filePath);
        }
    }

    public static void createFile(String filePath) throws IOException {
        Files.createFile(Paths.get(filePath, new String[0]), new FileAttribute[0]);
    }
}

