/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.generate.artifact.info;

import com.ibm.urbancode.zos.deploy.xml.utils.ContainerResource;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import com.ibm.urbancode.zos.deploy.xml.utils.RollbackManifest;
import com.ibm.urbancode.zos.deploy.xml.utils.RollbackManifestContainer;
import com.ibm.urbancode.zos.generate.artifact.info.ElementsSorter;
import com.ibm.urbancode.zos.generate.artifact.info.FilterInputs;
import com.ibm.urbancode.zos.generate.artifact.info.InfoMatcher;
import java.util.Map;
import java.util.Set;

public class FilterHelper {
    public static final String SOURCE_DATASET = "sourceDataset";
    public static final String DATASET = "dataset";
    public static final String MEMBER = "member";
    public static final String DEPLOY_TYPE = "deployType";
    public static final String ARTIFACT_GROUP = "artifactGroup";
    public static final String ARTIFACT = "artifact";
    public static final String DIRECTORY = "directory";
    public static final String FILE = "file";
    public static final String INPUTS_URL = "inputsUrl";
    private final FilterInputs filterInputs;
    private final Map<String, RollbackManifestContainer> rollbackManifestContainerMap;

    public FilterHelper(FilterInputs filterInputs, RollbackManifest rollbackManifest) {
        this.filterInputs = filterInputs;
        this.rollbackManifestContainerMap = this.getContainersBasedOnAction(rollbackManifest);
    }

    private Map<String, RollbackManifestContainer> getContainersBasedOnAction(RollbackManifest rollbackManifest) {
        if (this.filterInputs.isCreatedDeployAction()) {
            return rollbackManifest.getCreatedContainersMap();
        }
        if (this.filterInputs.isUpdatedDeployAction()) {
            return rollbackManifest.getUpdatedContainersMap();
        }
        return rollbackManifest.getDeletedContainersMap();
    }

    public boolean isLoopTypeMatched(ManifestContainer container) {
        if (InfoMatcher.isContainerTypeCompatibleWithLoopType(container.getType(), this.filterInputs.getLoopType())) {
            return true;
        }
        System.out.println("  Not selected because LoopType=" + this.filterInputs.getLoopType() + " is not applicable for container type");
        return false;
    }

    public boolean isDeletedMissingMemberToBeIncluded(ManifestContainer container, ContainerResource resource) {
        String resourceName;
        String containerName;
        RollbackManifestContainer rollbackManifestContainer;
        Map resourceMap;
        ContainerResource rollbackResource;
        if (this.filterInputs.getLoopType().equals("DeletedMemberExcludingMissingMembers") && (rollbackResource = (ContainerResource)(resourceMap = (rollbackManifestContainer = this.rollbackManifestContainerMap.get(containerName = container.getTargetContainerName())).getResourceMap()).get(resourceName = resource.getName())).isMissing()) {
            System.out.println("  Not selected because " + containerName + "(" + resourceName + ") was a deleted missing member during version deployment");
            return false;
        }
        return true;
    }

    public boolean isResourceDeployActionMatched(ManifestContainer container, ContainerResource resource) {
        if (this.filterInputs.isDeployActionPassed()) {
            String containerName = container.getTargetContainerName();
            String resourceName = resource.getName();
            if (!this.rollbackManifestContainerMap.containsKey(containerName)) {
                System.out.println(" Not selected because " + containerName + "(" + resourceName + ") was not " + this.filterInputs.getDeployAction() + " during version deployment");
                return false;
            }
            Map resourceMap = this.rollbackManifestContainerMap.get(containerName).getResourceMap();
            if (!resourceMap.containsKey(resourceName)) {
                System.out.println(" Not selected because " + containerName + "(" + resourceName + ") was not " + this.filterInputs.getDeployAction() + " during version deployment");
                return false;
            }
        }
        return true;
    }

    public boolean isDeployActionMatched(ManifestContainer container) {
        if (this.filterInputs.isDeployActionPassed() && !this.rollbackManifestContainerMap.containsKey(container.getTargetContainerName())) {
            System.out.println(" Not selected because container " + container.getTargetContainerName() + " is not " + this.filterInputs.getDeployAction());
            return false;
        }
        return true;
    }

    public boolean isContainerDeployTypeMatched(ManifestContainer container) {
        if (InfoMatcher.isMatched(this.filterInputs.getDeployType(), container.getDeployType())) {
            return true;
        }
        System.out.println("  Not selected because DeploymentAction=" + this.filterInputs.getDeployType() + " does not match");
        return false;
    }

    public boolean isSourceMatched(ManifestContainer container) {
        if (InfoMatcher.isMatched(this.filterInputs.getSourceDataset(), container.getSourceContainerName())) {
            return true;
        }
        System.out.println("  Not selected because SourceContainer=" + this.filterInputs.getSourceDataset() + " does not match");
        return false;
    }

    public boolean isTargetMatched(ManifestContainer container) {
        if (InfoMatcher.isMatched(this.filterInputs.getTargetDataset(), container.getTargetContainerName())) {
            return true;
        }
        System.out.println("  Not selected because TargetContainer=" + this.filterInputs.getTargetDataset() + " does not match");
        return false;
    }

    public boolean isMemberMatched(ContainerResource resource) {
        if (InfoMatcher.isMatched(this.filterInputs.getMember(), resource.getName())) {
            return true;
        }
        System.out.println("  Not selected because Resource=" + this.filterInputs.getMember() + " does not match");
        return false;
    }

    public boolean isResourceDeployTypeMatched(ContainerResource resource) {
        if (InfoMatcher.isMatched(this.filterInputs.getDeployType(), resource.getDeployType())) {
            return true;
        }
        System.out.println("  Not selected because DeploymentAction=" + this.filterInputs.getDeployType() + " does not match");
        return false;
    }

    public boolean isNotMissingDeletedMember(ContainerResource resource) {
        String loopType = this.filterInputs.getLoopType();
        if (loopType.equals("DeletedMemberExcludingMissingMembers") && resource.isMissing()) {
            System.out.println("  Not selected because " + resource.getName() + " is a deleted missing resource");
            return false;
        }
        return true;
    }

    public boolean areContainerCustomPropertiesMatched(ManifestContainer container) {
        Map<String, String> customPropertiesFilter = this.filterInputs.getCustomProperties();
        for (Map.Entry<String, String> filterProperty : customPropertiesFilter.entrySet()) {
            if (InfoMatcher.isPropertyMatched(filterProperty.getKey(), filterProperty.getValue(), container.getCustomerProperties())) continue;
            System.out.println("  Not selected because CustomProperty " + filterProperty.getKey() + "=" + filterProperty.getValue() + " does not match");
            return false;
        }
        return true;
    }

    public boolean areResourceCustomPropertiesMatched(ContainerResource resource) {
        Map<String, String> customPropertiesFilter = this.filterInputs.getCustomProperties();
        for (Map.Entry<String, String> filterProperty : customPropertiesFilter.entrySet()) {
            if (InfoMatcher.isPropertyMatched(filterProperty.getKey(), filterProperty.getValue(), resource.getCustomerProperties())) continue;
            System.out.println("  Not selected because CustomProperty " + filterProperty.getKey() + "=" + filterProperty.getValue() + " does not match");
            return false;
        }
        return true;
    }

    public Set<ContainerResource> getOrderedResources(Set<ContainerResource> resources) {
        return new ElementsSorter<ContainerResource>(resources, this.filterInputs.getOrderBy()).sort();
    }
}

