/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.generate.artifact.info;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class LoopType {
    private static final String DELETED = "deleted";
    public static final String MEMBER = "Member";
    public static final String PDS = "PDS";
    public static final String DELETED_MEMBER = "DeletedMember";
    public static final String DELETED_PDS = "DeletedPDS";
    public static final String SEQUENTIAL = "Sequential";
    public static final String DELETED_SEQUENTIAL = "DeletedSequential";
    public static final String DIRECTORY = "Directory";
    public static final String FILE = "File";
    public static final String DELETED_FILE = "DeletedFile";
    public static final String GENERIC_ARTIFACT_GROUP = "GenericArtifactGroup";
    public static final String GENERIC_ARTIFACT = "GenericArtifact";
    public static final String DELETED_MEMBER_EXCLUDING_MISSING_MEMBERS = "DeletedMemberExcludingMissingMembers";
    private static final Set<String> containerLevels = Stream.of("PDS", "DeletedPDS", "Sequential", "DeletedSequential", "GenericArtifactGroup", "Directory").collect(Collectors.toSet());
    private static final Set<String> resourceLevels = Stream.of("Member", "DeletedMember", "DeletedMemberExcludingMissingMembers", "GenericArtifact", "File", "DeletedFile").collect(Collectors.toSet());

    private LoopType() {
    }

    public static boolean isDeleted(String loopType) {
        return loopType.toLowerCase().contains(DELETED);
    }

    public static boolean isContainerLevel(String loopType) {
        return containerLevels.contains(loopType);
    }

    public static boolean isResourceLevel(String loopType) {
        return resourceLevels.contains(loopType);
    }

    public static boolean isDatasetLevel(String loopType) {
        if (loopType.contains(PDS)) {
            return true;
        }
        if (loopType.contains(MEMBER)) {
            return true;
        }
        return loopType.contains(SEQUENTIAL);
    }
}

