/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.generate.artifact.info;

import com.ibm.urbancode.zos.deploy.xml.utils.ContainerResource;
import com.ibm.urbancode.zos.deploy.xml.utils.ManifestContainer;
import java.util.HashMap;
import java.util.Map;

public final class TemplateTokens {
    private static final String EMPTY_MEMBER_NAME = "";

    private TemplateTokens() {
    }

    public static Map<String, String> get(ManifestContainer container) {
        HashMap<String, String> replaceTokens = new HashMap<String, String>(container.getCustomerProperties());
        if (container.isGeneric()) {
            replaceTokens.putAll(TemplateTokens.getGenericTokens(container.getSourceContainerName(), EMPTY_MEMBER_NAME));
        } else if (container.isDirectory()) {
            replaceTokens.putAll(TemplateTokens.getHfsTokens(container.getSourceContainerName(), EMPTY_MEMBER_NAME));
        } else {
            replaceTokens.putAll(TemplateTokens.getMvsTokens(container, EMPTY_MEMBER_NAME));
        }
        if (container.getDeployType() != null) {
            replaceTokens.put("deployType", container.getDeployType());
        }
        return replaceTokens;
    }

    public static Map<String, String> get(ManifestContainer container, ContainerResource resource) {
        HashMap<String, String> replaceTokens = new HashMap<String, String>(resource.getCustomerProperties());
        if (container.isGeneric()) {
            replaceTokens.putAll(TemplateTokens.getGenericTokens(container.getSourceContainerName(), resource.getName()));
        } else if (container.isDirectory()) {
            replaceTokens.putAll(TemplateTokens.getHfsTokens(container.getSourceContainerName(), resource.getName()));
        } else {
            replaceTokens.putAll(TemplateTokens.getMvsTokens(container, resource.getName()));
        }
        if (resource.getDeployType() != null) {
            replaceTokens.put("deployType", resource.getDeployType());
        }
        replaceTokens.put("inputsUrl", resource.getInputs().getUrl());
        return replaceTokens;
    }

    private static Map<String, String> getMvsTokens(ManifestContainer container, String resourceName) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put("sourceDataset", container.getSourceContainerName());
        tokens.put("dataset", container.getTargetContainerName());
        tokens.put("member", resourceName);
        return tokens;
    }

    private static Map<String, String> getGenericTokens(String containerSrcName, String resourceName) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put("artifactGroup", containerSrcName);
        tokens.put("artifact", resourceName);
        return tokens;
    }

    private static Map<String, String> getHfsTokens(String containerSrcName, String resourceName) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put("directory", containerSrcName);
        tokens.put("file", resourceName);
        return tokens;
    }
}

