/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.hfs;

import com.ibm.team.enterprise.automation.hfs.HFSUtil;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.deployment.hfs.BackupFilesTask;
import com.ibm.team.enterprise.deployment.hfs.Messages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Echo;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeployFilesTask
extends Task {
    private File manifestFile;
    private File outputDir;
    private File containerMapperHfsFile;
    private boolean oldVersionIdentifier;
    private boolean deleteCurrentContents;

    public void execute() throws BuildException {
        if (this.manifestFile != null && this.manifestFile.exists()) {
            try {
                Manifest packageManifest = ManifestReader.getInstance().getManifest(this.manifestFile);
                List createOrUpdateContainers = HFSUtil.getHFSContainers((List)packageManifest.getContainers());
                createOrUpdateContainers.addAll(HFSUtil.getHFSContainers((List)packageManifest.getCreatedContainers()));
                createOrUpdateContainers.addAll(HFSUtil.getHFSContainers((List)packageManifest.getUpdatedContainers()));
                List deletedContainers = HFSUtil.getHFSContainers((List)packageManifest.getDeletedContainers());
                if (createOrUpdateContainers.isEmpty() && deletedContainers.isEmpty()) {
                    this.getProject().log(Messages.DeployFilesTask_NOTHING_TO_DEPLOY_INFO_MSG, 2);
                }
                File sourceDir = new File(this.outputDir, "HFS");
                try {
                    File targetOutputsDir;
                    File inputFile = new File(this.containerMapperHfsFile.toString());
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(inputFile);
                    doc.getDocumentElement().normalize();
                    NodeList nList = doc.getElementsByTagName("map");
                    ArrayList<String> sourceList = new ArrayList<String>();
                    ArrayList<String> targetList = new ArrayList<String>();
                    for (int temp = 0; temp < nList.getLength(); ++temp) {
                        Element element;
                        Node node1;
                        int count;
                        Node nNode = nList.item(temp);
                        if (nNode.getNodeType() != 1) continue;
                        Element eElement = (Element)nNode;
                        NodeList sourceContainerList = eElement.getElementsByTagName("sourceContainer");
                        NodeList targetContainerList = eElement.getElementsByTagName("targetContainer");
                        for (count = 0; count < sourceContainerList.getLength(); ++count) {
                            node1 = sourceContainerList.item(count);
                            if (node1.getNodeType() != 1) continue;
                            element = (Element)node1;
                            sourceList.add(element.getAttribute("name"));
                        }
                        for (count = 0; count < targetContainerList.getLength(); ++count) {
                            node1 = targetContainerList.item(count);
                            if (node1.getNodeType() != 1) continue;
                            element = (Element)node1;
                            targetList.add(element.getAttribute("name"));
                        }
                    }
                    if (this.deleteCurrentContents) {
                        this.echoMessage("Deleting contents in Target Directory:");
                        HashSet<String> deleteCurrentContentsSet = new HashSet<String>();
                        for (Container container : createOrUpdateContainers) {
                            int containerIndex = 0;
                            String containerName = File.separator + container.getName();
                            if (!sourceList.contains(containerName)) {
                                throw new Exception(" [Error] SourceList does not contain container name " + containerName);
                            }
                            containerIndex = sourceList.indexOf(containerName);
                            File targetOutputsDir2 = new File((String)targetList.get(containerIndex)).getCanonicalFile();
                            if (!deleteCurrentContentsSet.add(targetOutputsDir2.getCanonicalPath()) || !targetOutputsDir2.exists() || !targetOutputsDir2.isDirectory()) continue;
                            this.deleteFilesTargetDir(targetOutputsDir2);
                        }
                    }
                    for (Container container : deletedContainers) {
                        int containerIndex = 0;
                        String containerName = File.separator + container.getName();
                        if (!sourceList.contains(containerName)) {
                            throw new Exception(" [Error] SourceList does not contain container name " + containerName);
                        }
                        containerIndex = sourceList.indexOf(containerName);
                        targetOutputsDir = new File((String)targetList.get(containerIndex));
                        this.deleteFiles(container, targetOutputsDir, packageManifest);
                    }
                    for (Container container : createOrUpdateContainers) {
                        int containerIndex = 0;
                        String containerName = File.separator + container.getName();
                        if (!sourceList.contains(containerName)) {
                            throw new Exception(" [Error] SourceList does not contain container name " + containerName);
                        }
                        containerIndex = sourceList.indexOf(containerName);
                        targetOutputsDir = new File((String)targetList.get(containerIndex)).getCanonicalFile();
                        this.copyFiles(container, sourceDir, targetOutputsDir);
                    }
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        } else {
            throw new BuildException(NLS.bind((String)Messages.BackupFilesTask_PACKAGE_MANIFEST_NOT_FOUND_ERROR_MSG, (Object)(this.manifestFile == null ? "" : this.manifestFile.getAbsolutePath())));
        }
    }

    private void copyFiles(Container container, File sourceDir, File targetDir) {
        Iterator resources = container.getResourcesIterator();
        while (resources.hasNext()) {
            Resource resource = (Resource)resources.next();
            String relativePath = container.getName() + File.separator + resource.getName();
            String tarRelativePath = "";
            tarRelativePath = this.oldVersionIdentifier ? targetDir + File.separator + container.getName() + File.separator + resource.getName() : targetDir + File.separator + resource.getName();
            File sourceFile = new File(sourceDir, relativePath);
            if (sourceFile.exists()) {
                File targetFile = new File(tarRelativePath);
                HFSUtil.move((File)sourceFile, (File)targetFile, (Project)this.getProject(), (boolean)true);
                continue;
            }
            throw new BuildException(NLS.bind((String)Messages.DeployFilesTask_FILE_NOT_FOUND, (Object)sourceFile.getAbsolutePath()));
        }
    }

    private void deleteFiles(Container container, File targetOutputsDir, Manifest packageManifest) throws IOException {
        File includesFile = new File(this.manifestFile.getParent() + File.separator + "deletionManifest.asHFSFileSet");
        PrintWriter includesFileOutput = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(includesFile))));
        String targetOutputsDirPath = "";
        targetOutputsDirPath = this.oldVersionIdentifier ? targetOutputsDir.getCanonicalPath() + File.separator + container.getName() : targetOutputsDir.getCanonicalPath();
        if (this.processFilesToDelete(container, targetOutputsDirPath, includesFileOutput, packageManifest, this.getProject())) {
            includesFileOutput.flush();
            includesFileOutput.close();
            Delete delete = (Delete)this.getProject().createTask("delete");
            delete.setVerbose(true);
            BufferedReader reader = new BufferedReader(new FileReader(includesFile));
            StringBuilder stringBuilder = new StringBuilder();
            String line = null;
            String ls = System.getProperty("line.separator");
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(ls);
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            reader.close();
            String content = stringBuilder.toString();
            String[] destIndexArray = content.split(ls);
            for (int i = 0; i < destIndexArray.length; ++i) {
                File f = new File(targetOutputsDirPath + File.separator + destIndexArray[i]);
                delete.setFile(f);
                delete.setFailOnError(true);
                delete.execute();
            }
        }
    }

    private boolean processFilesToDelete(Container container, String outputsDirPath, PrintWriter includesFileOutput, Manifest packageManifest, Project project) {
        HashMap deltaContainerMapping = new HashMap();
        boolean addedIncludes = false;
        Iterator resources = container.getResourcesIterator();
        while (resources.hasNext()) {
            Resource resource = (Resource)resources.next();
            String relativePath = resource.getName();
            FileSet fileSet = new FileSet();
            fileSet.setProject(project);
            fileSet.setDir(new File(outputsDirPath));
            fileSet.createInclude().setName(relativePath);
            HashMap<String, HashSet<Resource>> directoryToResourceMapping = new HashMap<String, HashSet<Resource>>();
            BackupFilesTask.scanFiles(fileSet, outputsDirPath, directoryToResourceMapping, project, resource);
            if (directoryToResourceMapping.size() <= 0) continue;
            Set<String> containerNames = directoryToResourceMapping.keySet();
            for (String containerName : containerNames) {
                boolean containerIsOutputsDir = false;
                if (!containerName.startsWith(outputsDirPath + File.separator) && !containerName.equals(outputsDirPath)) continue;
                containerIsOutputsDir = container.getName().equals(outputsDirPath);
                String deltaContainerName = containerIsOutputsDir ? "." : container.getName();
                Container deltaContainer = (Container)deltaContainerMapping.get(deltaContainerName);
                if (deltaContainer == null) {
                    deltaContainer = new Container();
                    deltaContainer.setType("directory");
                    deltaContainer.setChangeType("DELETE");
                    deltaContainer.setName(deltaContainerName);
                }
                for (Resource newResource : directoryToResourceMapping.get(containerName)) {
                    String includePath = newResource.getName();
                    includesFileOutput.println(includePath);
                    addedIncludes = true;
                }
            }
        }
        return addedIncludes;
    }

    private void deleteFilesTargetDir(File targetOutputsDir) throws IOException {
        Delete delete = (Delete)this.getProject().createTask("delete");
        delete.setDir(targetOutputsDir);
        delete.setFailOnError(true);
        delete.setVerbose(true);
        delete.execute();
    }

    private void echoMessage(String message) {
        Echo echo = (Echo)this.getProject().createTask("echo");
        echo.setMessage(message);
        echo.execute();
    }

    public void setManifest(File manifest) {
        this.manifestFile = manifest;
    }

    public void setOutputDir(File dir) {
        this.outputDir = dir;
    }

    public File getcontainerMapperHfsFile() {
        return this.containerMapperHfsFile;
    }

    public void setcontainerMapperHfsFile(File containerMapperHfsFile) {
        this.containerMapperHfsFile = containerMapperHfsFile;
    }

    public boolean isoldVersionIdentifier() {
        return this.oldVersionIdentifier;
    }

    public void setoldVersionIdentifier(boolean oldVersionIdentifier) {
        this.oldVersionIdentifier = oldVersionIdentifier;
    }

    public boolean isDeleteCurrentContents() {
        return this.deleteCurrentContents;
    }

    public void setDeleteCurrentContents(boolean deleteCurrentContents) {
        this.deleteCurrentContents = deleteCurrentContents;
    }
}

