/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.stream.Stream;

public final class FileHelper {
    private static final String ENCODING_IBM1047 = "IBM-1047";

    private FileHelper() {
    }

    public static boolean isFileNotExist(String filePath) {
        return !FileHelper.isFileExist(filePath);
    }

    public static boolean isFileExist(String filePath) {
        return new File(filePath).isFile();
    }

    public static void cleanDirectory(String directoryPath) throws IOException {
        if (new File(directoryPath).isDirectory()) {
            try (Stream<Path> pathStream = Files.walk(Paths.get(directoryPath, new String[0]), new FileVisitOption[0]);){
                pathStream.map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(File::delete);
            }
        }
    }

    public static boolean isDirectoryNotExist(String directoryPath) {
        return !new File(directoryPath).isDirectory();
    }

    public static void changeEncodingAttributeToIBM1047(String xmlFilePath) throws IOException {
        Path path = Paths.get(xmlFilePath, new String[0]);
        String content = new String(Files.readAllBytes(path));
        content = content.replace("xml version=\"1.0\" encoding=\"UTF-8\"", "xml version=\"1.0\" encoding=\"IBM-1047\"");
        Files.write(path, content.getBytes(), new OpenOption[0]);
    }

    public static void writeStringToFile(String xmlString, String filePath) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, Charset.forName(ENCODING_IBM1047), new OpenOption[0]);){
            writer.write(xmlString);
        }
    }
}

