/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.xml.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ManifestVersion {
    private static final String ENCODING_CP037 = "CP037";
    private static final String MANIFEST_NODE = "manifest";
    private static final String MANIFEST_VERSION_ATTRIBUTE = "version";
    private static final String V_2_0 = "v2_0";

    private ManifestVersion() {
    }

    public static boolean isV2(String manifestPath) throws XMLStreamException, IOException {
        return ManifestVersion.isV2(manifestPath, ENCODING_CP037);
    }

    protected static boolean isV2(String manifestPath, String encoding) throws XMLStreamException, IOException {
        try (InputStream manifestInputStream = Files.newInputStream(Paths.get(manifestPath, new String[0]), new OpenOption[0]);){
            boolean bl = ManifestVersion.isManifestVersion2(encoding, manifestInputStream);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isManifestVersion2(String encoding, InputStream manifestInputStream) throws XMLStreamException {
        boolean isNewPackage = false;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try (XMLStreamReader xmlStreamReader = null;){
            xmlStreamReader = inputFactory.createXMLStreamReader(manifestInputStream, encoding);
            while (xmlStreamReader.hasNext()) {
                String nodeName;
                if (xmlStreamReader.next() != 1 || !MANIFEST_NODE.equalsIgnoreCase(nodeName = xmlStreamReader.getName().getLocalPart().trim())) continue;
                String versionValue = xmlStreamReader.getAttributeValue(null, MANIFEST_VERSION_ATTRIBUTE);
                isNewPackage = versionValue != null && versionValue.equals(V_2_0);
                break;
            }
        }
        return isNewPackage;
    }
}

